/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.endcondition;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import osmo.tester.OSMOConfiguration;
import osmo.tester.generator.endcondition.EndCondition;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;

public class Time
implements EndCondition {
    private boolean shouldEnd = false;
    private final long delay;
    private final TimeUnit timeUnit;

    public Time(long hours, long minutes, long seconds) {
        this(hours * 60L * 60L + minutes * 60L + seconds);
    }

    public Time(long minutes, long seconds) {
        this(minutes * 60L + seconds);
    }

    public Time(long seconds) {
        this(seconds, TimeUnit.SECONDS);
    }

    public Time(long delay, TimeUnit timeUnit) {
        if (delay <= 0L) {
            throw new IllegalArgumentException("Time for " + Time.class.getSimpleName() + " should be > 0, was " + delay);
        }
        this.delay = delay;
        this.timeUnit = timeUnit;
    }

    @Override
    public boolean endSuite(TestSuite suite, FSM fsm) {
        return this.shouldEnd;
    }

    @Override
    public boolean endTest(TestSuite suite, FSM fsm) {
        return this.shouldEnd;
    }

    @Override
    public void init(long seed, FSM fsm, OSMOConfiguration config) {
        this.shouldEnd = false;
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        Runnable task = () -> {
            this.shouldEnd = true;
        };
        executor.schedule(task, this.delay, this.timeUnit);
    }

    public long getDelay() {
        return this.delay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String toString() {
        return "Time{delay=" + this.delay + ", timeUnit=" + (Object)((Object)this.timeUnit) + '}';
    }

    @Override
    public EndCondition cloneMe() {
        return new Time(this.delay, this.timeUnit);
    }
}

