/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.endcondition;

import java.util.ArrayList;
import java.util.List;
import osmo.common.Randomizer;
import osmo.tester.OSMOConfiguration;
import osmo.tester.generator.endcondition.EndCondition;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;

public class WeightedEndConditionSet
implements EndCondition {
    private List<Integer> weights = new ArrayList<Integer>();
    private List<EndCondition> endConditions = new ArrayList<EndCondition>();
    private EndCondition ec = null;

    public WeightedEndConditionSet(int weight1, EndCondition ec1, int weight2, EndCondition ec2) {
        this.weights.add(weight1);
        this.weights.add(weight2);
        this.endConditions.add(ec1);
        this.endConditions.add(ec2);
    }

    public void addEndCondition(int weight, EndCondition ec) {
        this.weights.add(weight);
        this.endConditions.add(ec);
    }

    @Override
    public boolean endSuite(TestSuite suite, FSM fsm) {
        return this.ec.endSuite(suite, fsm);
    }

    @Override
    public boolean endTest(TestSuite suite, FSM fsm) {
        return this.ec.endTest(suite, fsm);
    }

    @Override
    public void init(long seed, FSM fsm, OSMOConfiguration config) {
        Randomizer rand = new Randomizer(seed);
        int index = rand.rawWeightedRandomFrom(this.weights);
        this.ec = this.endConditions.get(index);
        this.ec.init(seed, fsm, config);
    }

    @Override
    public EndCondition cloneMe() {
        WeightedEndConditionSet clone = new WeightedEndConditionSet(this.weights.get(0), this.endConditions.get(0).cloneMe(), this.weights.get(1), this.endConditions.get(1).cloneMe());
        for (int i = 2; i < this.endConditions.size(); ++i) {
            clone.addEndCondition(this.weights.get(i), this.endConditions.get(i).cloneMe());
        }
        return clone;
    }
}

