/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.endcondition.logical;

import java.util.Arrays;
import osmo.tester.OSMOConfiguration;
import osmo.tester.generator.endcondition.EndCondition;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;

public class Or
implements EndCondition {
    private final EndCondition[] conditions;

    public Or(EndCondition ... conditions) {
        this.conditions = conditions;
    }

    @Override
    public boolean endSuite(TestSuite suite, FSM fsm) {
        for (EndCondition condition : this.conditions) {
            if (!condition.endSuite(suite, fsm)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean endTest(TestSuite suite, FSM fsm) {
        for (EndCondition condition : this.conditions) {
            if (!condition.endTest(suite, fsm)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void init(long seed, FSM fsm, OSMOConfiguration config) {
        for (EndCondition condition : this.conditions) {
            condition.init(seed, fsm, config);
        }
    }

    public String toString() {
        return "Or{conditions=" + (this.conditions == null ? null : Arrays.asList(this.conditions)) + '}';
    }

    @Override
    public EndCondition cloneMe() {
        EndCondition[] clones = new EndCondition[this.conditions.length];
        for (int i = 0; i < this.conditions.length; ++i) {
            clones[i] = this.conditions[i].cloneMe();
        }
        Or clone = new Or(clones);
        return clone;
    }
}

