/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.endcondition.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;

public class ElementCoverageRequirement {
    private int steps = 0;
    private int pairs = 0;
    private int requirements = 0;
    private boolean check = true;

    public ElementCoverageRequirement(int steps, int pairs, int requirements) {
        this.steps = steps;
        this.pairs = pairs;
        this.requirements = requirements;
    }

    public void setCheck(boolean check) {
        this.check = check;
    }

    public void init(FSM fsm) {
        Collection<FSMTransition> transitions = fsm.getTransitions();
        int maxSteps = transitions.size();
        if (this.steps < 0) {
            this.steps = maxSteps;
        }
        if (this.check && this.steps > maxSteps) {
            throw new IllegalArgumentException("Too many steps requested (model has " + maxSteps + ", requested " + this.steps + ").");
        }
        ArrayList<String> names = new ArrayList<String>();
        for (FSMTransition transition : transitions) {
            names.add(transition.getStringName());
        }
        int maxPairs = names.size() * names.size() + 1;
        if (this.pairs < 0) {
            this.pairs = maxPairs;
        }
        if (this.check && this.pairs > maxPairs) {
            throw new IllegalArgumentException("Too many pairs requested (model has " + maxPairs + ", requested " + this.pairs + ").");
        }
        int fsmRequirements = fsm.getRequirements().getRequirements().size();
        if (this.requirements < 0) {
            this.requirements = fsmRequirements;
        }
        if (this.check && this.requirements > 0 && this.requirements > fsmRequirements) {
            throw new IllegalArgumentException("Too many requirements requested (model has " + fsmRequirements + ", requested " + this.requirements + ").");
        }
    }

    public boolean checkCoverage(TestSuite suite) {
        TestCoverage coverage = suite.getCoverage();
        if (this.pairs > 0 && this.pairs > coverage.getStepPairs().size()) {
            return false;
        }
        if (this.requirements > 0 && this.requirements > coverage.getRequirements().size()) {
            return false;
        }
        return this.steps <= 0 || this.steps <= coverage.getSingles().size();
    }

    public boolean checkCoverage(TestCase test) {
        TestCoverage tc = test.getCoverage();
        if (this.requirements > 0 && this.requirements > tc.getRequirements().size()) {
            return false;
        }
        if (this.steps > 0 && this.steps > tc.getSingles().size()) {
            return false;
        }
        return this.pairs <= 0 || this.pairs <= tc.getStepPairs().size();
    }

    public int countPairs(List<String> names) {
        LinkedHashSet<String> pairs = new LinkedHashSet<String>();
        String previous = "start";
        for (String name : names) {
            String pair = previous + "->" + name;
            pairs.add(pair);
            previous = name;
        }
        return pairs.size();
    }
}

