/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.endcondition.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.generator.endcondition.EndCondition;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestCaseStep;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;

public class StepCoverage
implements EndCondition {
    private static final Logger log = new Logger(StepCoverage.class);
    private Collection<String> required = new ArrayList<String>();

    public StepCoverage(String ... stepsToCover) {
        Collections.addAll(this.required, stepsToCover);
    }

    @Override
    public boolean endSuite(TestSuite suite, FSM fsm) {
        log.d("suite check");
        List<TestCase> allTests = suite.getAllTestCases();
        ArrayList<String> steps = new ArrayList<String>();
        for (TestCase test : allTests) {
            steps.addAll(this.stepsFor(test));
        }
        return this.checkRequiredSteps(steps);
    }

    private boolean checkRequiredSteps(Collection<String> steps) {
        ArrayList<String> remaining = new ArrayList<String>();
        log.d("steps:" + steps);
        remaining.addAll(this.required);
        for (String step : steps) {
            remaining.remove(step);
        }
        log.d("remaining:" + remaining);
        return remaining.size() == 0;
    }

    private Collection<String> stepsFor(TestCase test) {
        List<TestCaseStep> testSteps = test.getSteps();
        ArrayList<String> steps = new ArrayList<String>();
        for (TestCaseStep step : testSteps) {
            steps.add(step.getName());
        }
        return steps;
    }

    @Override
    public boolean endTest(TestSuite suite, FSM fsm) {
        log.d("test check");
        TestCase test = suite.getCurrentTest();
        Collection<String> steps = this.stepsFor(test);
        return this.checkRequiredSteps(steps);
    }

    public void addRequiredStep(String step) {
        this.required.add(step);
    }

    @Override
    public void init(long seed, FSM fsm, OSMOConfiguration config) {
        Collection<FSMTransition> transitions = fsm.getTransitions();
        LinkedHashSet<String> toClear = new LinkedHashSet<String>();
        toClear.addAll(this.required);
        for (FSMTransition transition : transitions) {
            String name = transition.getStringName();
            boolean ok = toClear.remove(name);
        }
        if (!toClear.isEmpty()) {
            throw new IllegalStateException("Impossible coverage requirements, defined steps " + toClear + " not found.");
        }
    }

    public String toString() {
        return "StepCoverage{required=" + this.required + '}';
    }

    @Override
    public EndCondition cloneMe() {
        return this;
    }
}

