/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.generator.filter.StepFilter;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestCaseStep;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;

public class MaxStepFilter
implements StepFilter {
    private static final Logger log = new Logger(MaxStepFilter.class);
    private Map<String, Integer> maximums = new LinkedHashMap<String, Integer>();
    private Map<String, Integer> taken = new LinkedHashMap<String, Integer>();

    public void setMax(String stepName, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("Step max count is now allowed to be negative. Was " + max + " for '" + stepName + "'.");
        }
        this.maximums.put(stepName, max);
    }

    @Override
    public void filter(Collection<FSMTransition> steps) {
        Iterator<FSMTransition> i = steps.iterator();
        while (i.hasNext()) {
            Integer max;
            FSMTransition transition = i.next();
            String name = transition.getStringName();
            Integer count = this.taken.get(name);
            if (count == null) {
                count = 0;
            }
            if ((max = this.maximums.get(name)) == null || count < max) continue;
            log.d("Removing transition '" + name + "' due to filtering.");
            i.remove();
        }
    }

    @Override
    public void init(long seed, FSM fsm, OSMOConfiguration config) {
        Collection<FSMTransition> transitions = fsm.getTransitions();
        ArrayList<String> shouldClear = new ArrayList<String>();
        shouldClear.addAll(this.maximums.keySet());
        for (FSMTransition transition : transitions) {
            String name = transition.getStringName();
            shouldClear.remove(name);
        }
        if (shouldClear.size() > 0) {
            throw new IllegalArgumentException("Specified steps do not exist in the model:" + shouldClear);
        }
    }

    @Override
    public void guard(FSMTransition transition) {
    }

    @Override
    public void stepStarting(TestCaseStep step) {
    }

    @Override
    public void stepDone(TestCaseStep step) {
        String name = step.getName();
        Integer count = this.taken.get(name);
        if (count == null) {
            count = 0;
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count + 1);
        this.taken.put(name, count);
    }

    @Override
    public void pre(FSMTransition transition) {
    }

    @Override
    public void post(FSMTransition transition) {
    }

    @Override
    public void testStarted(TestCase test) {
        this.taken.clear();
    }

    @Override
    public void testEnded(TestCase test) {
    }

    @Override
    public void suiteStarted(TestSuite suite) {
    }

    @Override
    public void suiteEnded(TestSuite suite) {
    }

    @Override
    public void testError(TestCase test, Throwable error) {
    }

    @Override
    public void lastStep(String name) {
    }
}

