/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.listener;

import java.io.PrintStream;
import osmo.tester.OSMOConfiguration;
import osmo.tester.generator.listener.GenerationListener;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestCaseStep;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;

public class TracePrinter
implements GenerationListener {
    private PrintStream out = System.out;
    private int testIndex = 1;
    private int stepIndex = 1;

    @Override
    public void init(long seed, FSM fsm, OSMOConfiguration config) {
    }

    @Override
    public void guard(FSMTransition transition) {
    }

    @Override
    public void stepStarting(TestCaseStep step) {
    }

    @Override
    public void stepDone(TestCaseStep step) {
        String name = step.getName();
        this.out.println(this.testIndex + "." + this.stepIndex + ".STEP:" + name.toUpperCase());
        ++this.stepIndex;
    }

    @Override
    public void lastStep(String name) {
        this.out.println(this.testIndex + "." + this.stepIndex + ".LASTSTEP:" + name.toUpperCase());
        ++this.stepIndex;
    }

    @Override
    public void pre(FSMTransition transition) {
    }

    @Override
    public void post(FSMTransition transition) {
    }

    @Override
    public void testStarted(TestCase test) {
    }

    @Override
    public void testEnded(TestCase test) {
        ++this.testIndex;
        this.stepIndex = 1;
    }

    @Override
    public void testError(TestCase test, Throwable error) {
        TestCaseStep currentStep = test.getCurrentStep();
        String name = ".osmo.tester.start.step";
        if (currentStep != null) {
            name = currentStep.getName();
        }
        this.out.println(this.testIndex + "." + this.stepIndex + ".ERROR:" + name.toUpperCase());
        ++this.stepIndex;
    }

    @Override
    public void suiteStarted(TestSuite suite) {
    }

    @Override
    public void suiteEnded(TestSuite suite) {
    }
}

