/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.testsuite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import osmo.common.log.Logger;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.generator.testsuite.TestCaseStep;
import osmo.tester.model.FSMTransition;

public class TestCase {
    private static final Logger log = new Logger(TestCase.class);
    private List<TestCaseStep> steps = new ArrayList<TestCaseStep>();
    private TestCaseStep currentStep = null;
    private final int id;
    private static AtomicInteger nextId = new AtomicInteger(1);
    private int nextStepId = 1;
    private Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private long startTime = 0L;
    private long endTime = 0L;
    private boolean failed = false;
    private TestCoverage coverage = new TestCoverage();
    private TestCoverage coverageClone = null;
    private final long seed;

    public TestCase(long seed) {
        this.id = nextId.getAndIncrement();
        this.seed = seed;
    }

    public static void reset() {
        nextId = new AtomicInteger(1);
    }

    public String getName() {
        return "Test" + this.id;
    }

    public int getId() {
        return this.id;
    }

    public TestCoverage getCoverage() {
        return this.coverage;
    }

    public void addCoverage(String variableName, String value) {
        this.coverage.addUserCoverage(variableName, value);
    }

    public TestCaseStep getCurrentStep() {
        return this.currentStep;
    }

    public int getParameterCount() {
        int max = 0;
        for (TestCaseStep step : this.steps) {
            int ps;
            Map<String, String> values = step.getValues();
            if (values == null || (ps = values.size()) <= max) continue;
            max = ps;
        }
        return max;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getDuration() {
        return this.endTime - this.startTime;
    }

    public TestCaseStep addStep(FSMTransition transition) {
        TestCaseStep step = new TestCaseStep(this, transition, this.nextStepId++);
        log.d("Added step:" + step);
        this.steps.add(step);
        this.currentStep = step;
        return step;
    }

    public List<TestCaseStep> getSteps() {
        return this.steps;
    }

    public Collection<String> getCoveredSteps() {
        LinkedHashSet<String> stepCoverage = new LinkedHashSet<String>();
        for (TestCaseStep step : this.steps) {
            stepCoverage.add(step.getName());
        }
        return stepCoverage;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public List<String> getAllStepNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (TestCaseStep step : this.steps) {
            names.add(step.getName());
        }
        return names;
    }

    public int getLength() {
        return this.steps.size();
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public String toString() {
        return "TestCase:" + this.steps.toString();
    }

    public void cloneCoverage() {
        this.coverageClone = new TestCoverage();
        this.coverageClone.addCoverage(this.coverage);
    }

    public void switchToClonedCoverage() {
        this.coverage = this.coverageClone;
    }

    public long getSeed() {
        return this.seed;
    }
}

