/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.testsuite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import osmo.common.ValuePair;
import osmo.common.log.Logger;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.model.FSMTransition;

public class TestCaseStep {
    private static final Logger log = new Logger(TestCaseStep.class);
    private final String transitionName;
    private final String modelObjectName;
    private final int id;
    private final TestCase parent;
    private long startTime = 0L;
    private long endTime = 0L;
    private boolean failed;
    private int addedCoverage;
    private Map<String, String> values;

    public TestCaseStep(TestCase parent, FSMTransition transition, int id) {
        this.parent = parent;
        this.transitionName = transition.getStringName();
        if (transition.getTransition() == null) {
            log.d("NULL transition object, assuming unit test in progress..");
            this.modelObjectName = transition.toString();
        } else {
            this.modelObjectName = transition.getModelObjectName();
        }
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.transitionName;
    }

    public String toString() {
        return this.transitionName;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void end() {
        this.endTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getModelObjectName() {
        return this.modelObjectName;
    }

    public TestCase getParent() {
        return this.parent;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public int getAddedCoverage() {
        return this.addedCoverage;
    }

    public void setAddedCoverage(int addedCoverage) {
        this.addedCoverage = addedCoverage;
    }

    public void addValue(String name, String value) {
        String myValues;
        if (this.values == null) {
            this.values = new LinkedHashMap<String, String>();
        }
        myValues = (myValues = this.values.get(name)) == null ? "" : myValues + ", ";
        myValues = myValues + value;
        this.values.put(name, myValues);
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public List<ValuePair<String>> getHtmlValues() {
        if (this.values == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ValuePair<String>> pairs = new ArrayList<ValuePair<String>>();
        for (String key : this.values.keySet()) {
            pairs.add(new ValuePair<String>(key, this.values.get(key)));
        }
        int max = this.parent.getParameterCount();
        for (int i = this.values.size(); i < max; ++i) {
            pairs.add(new ValuePair<String>("", ""));
        }
        return pairs;
    }
}

