/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.generator.testsuite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import osmo.common.log.Logger;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestCaseStep;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;
import osmo.tester.model.Requirements;
import osmo.tester.model.VariableField;

public class TestSuite {
    private static final Logger log = new Logger(TestSuite.class);
    private TestCase current = null;
    private final List<TestCase> testCases = new ArrayList<TestCase>();
    private Requirements requirements;
    private TestCoverage coverage = new TestCoverage();
    private TestCoverage testCoverage = null;
    private boolean trackParameters = false;
    private boolean keepTests = true;
    private int testCount = 0;

    public TestSuite(TestCoverage coverage) {
        this.coverage = coverage;
    }

    public TestSuite() {
    }

    public void setKeepTests(boolean keepTests) {
        this.keepTests = keepTests;
    }

    public int currentTestNumber() {
        return this.testCount;
    }

    public TestCase startTest(long seed) {
        this.current = new TestCase(seed);
        this.current.setStartTime(System.currentTimeMillis());
        this.testCoverage = this.current.getCoverage();
        return this.current;
    }

    public void endTest() {
        ++this.testCount;
        this.current.setEndTime(System.currentTimeMillis());
        if (this.keepTests) {
            this.testCases.add(this.current);
        }
        this.current = null;
        this.coverage.addCoverage(this.testCoverage);
    }

    public TestCaseStep addStep(FSMTransition transition) {
        this.testCoverage.addStep(transition.getStringName());
        TestCaseStep step = this.current.addStep(transition);
        return step;
    }

    public int totalSteps() {
        int count = 0;
        for (TestCase test : this.testCases) {
            count += test.getSteps().size();
        }
        if (this.current != null) {
            count += this.current.getSteps().size();
        }
        return count;
    }

    public TestCase getCurrentTest() {
        return this.current;
    }

    public List<TestCase> getAllTestCases() {
        ArrayList<TestCase> all = new ArrayList<TestCase>(this.testCases.size() + 1);
        all.addAll(this.testCases);
        if (this.current != null) {
            all.add(this.current);
        }
        return all;
    }

    public int currentSteps() {
        if (this.current == null) {
            return 0;
        }
        return this.current.getSteps().size();
    }

    public boolean contains(FSMTransition transition) {
        for (TestCase testCase : this.testCases) {
            if (!this.testContains(testCase, transition)) continue;
            return true;
        }
        return this.current != null && this.testContains(this.current, transition);
    }

    private boolean testContains(TestCase testCase, FSMTransition transition) {
        List<TestCaseStep> steps = testCase.getSteps();
        for (TestCaseStep step : steps) {
            if (!step.getName().equals(transition.getStringName())) continue;
            return true;
        }
        return false;
    }

    public void initRequirements(Requirements requirements) {
        if (requirements == null) {
            log.d("No requirements object defined. Creating new.");
            requirements = new Requirements();
        }
        this.requirements = requirements;
        requirements.setTestSuite(this);
    }

    public Requirements getRequirements() {
        return this.requirements;
    }

    public TestCoverage getCoverage() {
        return this.coverage;
    }

    public void addValue(String inputName, Object value) {
        String strValue = "" + value;
        this.testCoverage.addVariableValue(inputName, strValue);
        if (this.trackParameters) {
            this.current.getCurrentStep().addValue(inputName, strValue);
        }
    }

    public void addUserCoverage(String name, String value) {
        this.testCoverage.addUserCoverage(name, value);
    }

    public void storeGeneralState(FSM fsm) {
        Collection<VariableField> variables = fsm.getModelVariables();
        for (VariableField variable : variables) {
            String name = variable.getName();
            Object value = variable.getValue();
            if (variable.isSearchableInput()) continue;
            this.addValue(name, "" + value);
        }
    }

    public void coveredRequirement(String name) {
        this.testCoverage.coveredRequirement(name);
    }

    public void enableParameterTracking() {
        this.trackParameters = true;
    }
}

