/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.gui.manualdrive;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import osmo.tester.OSMOConfiguration;
import osmo.tester.OSMOTester;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.generator.algorithm.BalancingAlgorithm;
import osmo.tester.generator.algorithm.FSMTraversalAlgorithm;
import osmo.tester.generator.algorithm.RandomAlgorithm;
import osmo.tester.generator.algorithm.WeightedRandomAlgorithm;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.gui.ModelHelper;
import osmo.tester.gui.manualdrive.GUIGenerationListener;
import osmo.tester.gui.manualdrive.ManualEndCondition;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;
import osmo.tester.model.VariableField;
import osmo.tester.model.data.SearchableInput;
import osmo.tester.reporting.trace.TraceReportWriter;

public class ManualAlgorithm
extends JFrame
implements FSMTraversalAlgorithm {
    private static JList availableStepsList;
    private static JTextPane testLogPane;
    private static JTextPane metricsPane;
    private static String choiceFromList;
    private static boolean autoplay;
    private static boolean lockAutoplay;
    private static JButton autoPlayButton;
    private static JTextPane autoPlayDelayTextPane;
    private static JComboBox algorithmComboBox;
    private static boolean running;
    private static TestSuite suite;
    private final RandomAlgorithm randomAlgorithm = new RandomAlgorithm();
    private final BalancingAlgorithm balancingAlgorithm = new BalancingAlgorithm();
    private final WeightedRandomAlgorithm weightedRandomAlgorithm = new WeightedRandomAlgorithm();
    private FSM fsm = null;
    private static final Object lock;
    private static final JButton btnEndTest;
    private static final JButton btnEndSuite;
    private static final JButton btnWriteScript;
    private final ManualEndCondition mec = new ManualEndCondition();
    private String historyText = "";

    public ManualAlgorithm(OSMOTester tester) {
        OSMOConfiguration config = tester.getConfig();
        config.setManual(true);
        config.setSuiteEndCondition(this.mec);
        config.setTestEndCondition(this.mec);
        tester.addListener(new GUIGenerationListener(this));
        this.setNimbus();
        this.setTitle("OSMOTester Manual Script Generation");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 600, 460);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        testLogPane.setEditable(false);
        testLogPane.setText("First Test Case starts");
        this.setContentPane(contentPane);
        JScrollPane scrollTestLog = new JScrollPane(testLogPane);
        JScrollPane testMetricsPaneScroll = new JScrollPane(metricsPane);
        JLabel lblTestLog = new JLabel("Test log");
        JLabel lblNextStep = new JLabel("Next Step");
        JLabel lblTraceability = new JLabel("Metrics");
        autoPlayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Integer.parseInt(autoPlayDelayTextPane.getText());
                }
                catch (Exception e2) {
                    return;
                }
                if (lockAutoplay) {
                    lockAutoplay = false;
                    return;
                }
                if (autoplay) {
                    autoplay = false;
                    lockAutoplay = true;
                    autoPlayButton.setText("Start autoplay");
                } else {
                    autoplay = true;
                    lockAutoplay = true;
                    autoPlayButton.setText("Stop autoplay");
                }
            }
        });
        metricsPane.setBackground(SystemColor.menu);
        metricsPane.setText("Test metrics");
        availableStepsList = new JList();
        availableStepsList.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                Object object = lock;
                synchronized (object) {
                    Object selectedValue = availableStepsList.getSelectedValue();
                    if (selectedValue == null) {
                        return;
                    }
                    choiceFromList = selectedValue.toString();
                    lock.notifyAll();
                }
            }
        });
        availableStepsList.setModel(new AbstractListModel(){
            private static final long serialVersionUID = 1L;
            String[] values = new String[]{"Empty!"};

            @Override
            public int getSize() {
                return this.values.length;
            }

            @Override
            public Object getElementAt(int index) {
                return this.values[index];
            }
        });
        availableStepsList.setAlignmentX(1.0f);
        autoPlayDelayTextPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    Integer.parseInt(autoPlayDelayTextPane.getText());
                }
                catch (Exception e2) {
                    autoPlayDelayTextPane.setBackground(Color.RED);
                    return;
                }
                autoPlayDelayTextPane.setBackground(Color.WHITE);
            }
        });
        autoPlayDelayTextPane.setText("1000");
        JLabel lblAutoPlayDelay = new JLabel("Auto play delay (ms)");
        algorithmComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"RandomAlgorithm", "BalancingRandomAlgorithm", "WeightedAlgorithm"}));
        btnEndTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("end test pressed");
                ManualAlgorithm.this.mec.setEndTest(true);
            }
        });
        btnEndSuite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualAlgorithm.this.mec.setEndSuite(true);
                ManualAlgorithm.this.mec.setEndTest(true);
            }
        });
        btnWriteScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualAlgorithm.this.writeScript();
            }
        });
        GroupLayout gl_contentPane = new GroupLayout(contentPane);
        gl_contentPane.setHorizontalGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPane.createSequentialGroup().addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(scrollTestLog, -1, 276, Short.MAX_VALUE).addComponent(lblNextStep).addComponent(availableStepsList, -1, -1, Short.MAX_VALUE)).addComponent(lblTestLog)).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPane.createSequentialGroup().addGap(18).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lblTraceability, -1, 270, Short.MAX_VALUE).addGroup(gl_contentPane.createSequentialGroup().addGap(22).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(btnEndSuite).addComponent(btnEndTest).addComponent(btnWriteScript)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 29, Short.MAX_VALUE).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(autoPlayDelayTextPane, -2, 101, -2).addComponent(autoPlayButton).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(algorithmComboBox, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(lblAutoPlayDelay, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)))))).addGroup(gl_contentPane.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(testMetricsPaneScroll, -1, 278, Short.MAX_VALUE))).addContainerGap()));
        gl_contentPane.setVerticalGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPane.createSequentialGroup().addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblTestLog).addComponent(lblTraceability)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPane.createSequentialGroup().addComponent(scrollTestLog, -2, 209, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(lblNextStep)).addComponent(testMetricsPaneScroll, -2, 209, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_contentPane.createSequentialGroup().addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_contentPane.createSequentialGroup().addComponent(algorithmComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblAutoPlayDelay).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(autoPlayDelayTextPane, -2, 19, -2)).addGroup(gl_contentPane.createSequentialGroup().addComponent(btnWriteScript).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnEndTest))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(autoPlayButton).addComponent(btnEndSuite))).addComponent(availableStepsList, -2, 144, -2)).addContainerGap()));
        contentPane.setLayout(gl_contentPane);
    }

    public void run(TestSuite suite) {
        if (!running) {
            ManualAlgorithm.suite = suite;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ManualAlgorithm.this.setVisible(true);
                        running = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.sleep(300);
        }
    }

    private String getSpaces(int a) {
        String ret = "";
        for (int i = 0; i < a; ++i) {
            ret = ret + " ";
        }
        return ret;
    }

    private String coverageText(TestSuite suite) {
        TestCoverage coverage = new TestCoverage();
        coverage.addCoverage(suite.getCoverage());
        coverage.addCoverage(suite.getCurrentTest().getCoverage());
        Map<String, Integer> a = coverage.getStepCoverage();
        String ret = "Number of times steps taken:\n";
        for (String t : a.keySet()) {
            ret = ret + t + this.getSpaces(30 - t.length()) + "\t" + a.get(t) + "\n";
        }
        ret = ret + "\nNumber of times variables used:\n";
        Map<String, Collection<String>> values = coverage.getVariableValues();
        for (String t : values.keySet()) {
            ret = ret + t + this.getSpaces(30 - t.length()) + "\t" + values.get(t).size() + "\n";
        }
        return ret;
    }

    private String stateText() {
        String text = "";
        Collection<VariableField> variables = this.fsm.getModelVariables();
        for (VariableField variable : variables) {
            text = text + variable.getName() + ": " + variable.getValue() + "\n";
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSelection() {
        Object object = lock;
        synchronized (object) {
            choiceFromList = null;
            if (autoplay) {
                int temp = 0;
                try {
                    temp = Integer.parseInt(autoPlayDelayTextPane.getText());
                    lock.wait(temp);
                }
                catch (Exception e) {
                    return;
                }
            } else {
                while (!(choiceFromList != null || autoplay || this.mec.endSuite(null, null) || this.mec.endTest(null, null))) {
                    try {
                        lock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void init(long seed, FSM fsm) {
        this.randomAlgorithm.init(seed, fsm);
        this.balancingAlgorithm.init(seed, fsm);
        this.weightedRandomAlgorithm.init(seed, fsm);
        this.fsm = fsm;
        Collection<VariableField> variables = fsm.getModelVariables();
        for (VariableField variable : variables) {
            Object value = variable.getValue();
            if (!(value instanceof SearchableInput)) continue;
            SearchableInput si = (SearchableInput)value;
            si.enableGUI();
            si.setChecked(true);
        }
        this.historyText = "GENERATION START\n";
    }

    @Override
    public FSMTransition choose(TestSuite suite, List<FSMTransition> choices) {
        this.run(suite);
        testLogPane.setText(this.historyText);
        testLogPane.setCaretPosition(testLogPane.getText().length());
        metricsPane.setText(this.stateText());
        metricsPane.setText(this.coverageText(suite));
        availableStepsList.setModel(new ModelHelper(choices));
        this.waitForSelection();
        if (this.mec.endSuite(null, null) || this.mec.endTest(null, null)) {
            return null;
        }
        for (FSMTransition t : choices) {
            String stepName = t.getName().toString();
            if (!stepName.equals(choiceFromList)) continue;
            choiceFromList = null;
            this.historyText = this.historyText + "STEP:" + stepName + "\n";
            return t;
        }
        switch (algorithmComboBox.getSelectedIndex()) {
            case 0: {
                return this.randomAlgorithm.choose(suite, choices);
            }
            case 1: {
                return this.balancingAlgorithm.choose(suite, choices);
            }
            case 2: {
                return this.weightedRandomAlgorithm.choose(suite, choices);
            }
        }
        throw new RuntimeException("Error in algorithm handler. The index was: " + algorithmComboBox.getSelectedIndex());
    }

    public void setNimbus() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeScript() {
        TraceReportWriter reporter = new TraceReportWriter();
        String filename = "osmo-output/manual-tests.html";
        try {
            reporter.write(suite.getAllTestCases(), filename);
            JOptionPane.showMessageDialog(this, "Wrote file to:" + filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testEnded() {
        availableStepsList.setEnabled(false);
        this.mec.setEndTest(false);
    }

    public void testStarted() {
        availableStepsList.setEnabled(true);
        this.historyText = this.historyText + "--= NEW TEST =--\n";
    }

    public void suiteEnded() {
        availableStepsList.setEnabled(false);
        autoPlayButton.setEnabled(false);
        btnEndTest.setEnabled(false);
        System.out.println("end test disabled");
        btnEndSuite.setEnabled(false);
    }

    @Override
    public void initTest(long seed) {
    }

    @Override
    public FSMTraversalAlgorithm cloneMe() {
        return null;
    }

    static {
        testLogPane = new JTextPane();
        metricsPane = new JTextPane();
        choiceFromList = null;
        autoplay = false;
        lockAutoplay = false;
        autoPlayButton = new JButton("Start auto play");
        autoPlayDelayTextPane = new JTextPane();
        algorithmComboBox = new JComboBox();
        running = false;
        suite = null;
        lock = new Object();
        btnEndTest = new JButton("End Test");
        btnEndSuite = new JButton("End Suite");
        btnWriteScript = new JButton("Write Script");
    }
}

