/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.gui.manualdrive;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import osmo.tester.model.data.SearchableInput;

public abstract class ValueGUI
extends JDialog {
    protected final SearchableInput input;
    protected Object value = null;
    private boolean observed = false;

    public ValueGUI(SearchableInput input) throws HeadlessException {
        this.input = input;
        this.setTitle(input.getName());
        this.setDefaultCloseOperation(0);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLayout(new BorderLayout());
        Container pane = this.getContentPane();
        pane.add((Component)new JLabel(this.createValueLabel()), "North");
        pane.add((Component)this.createValueComponent(), "Center");
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                ValueGUI.this.value = ValueGUI.this.value();
                if (ValueGUI.this.value == null) {
                    return;
                }
                ValueGUI.this.setVisible(false);
                ValueGUI valueGUI = ValueGUI.this;
                synchronized (valueGUI) {
                    ValueGUI.this.notify();
                }
            }
        });
        JButton skip = new JButton("Skip");
        skip.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                ValueGUI.this.value = null;
                ValueGUI.this.setVisible(false);
                ValueGUI.this.observed = true;
                ValueGUI valueGUI = ValueGUI.this;
                synchronized (valueGUI) {
                    ValueGUI.this.notify();
                }
            }
        });
        JButton auto = new JButton("Auto");
        auto.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                ValueGUI.this.input.disableGUI();
                ValueGUI.this.value = null;
                ValueGUI.this.setVisible(false);
                ValueGUI.this.observed = true;
                ValueGUI valueGUI = ValueGUI.this;
                synchronized (valueGUI) {
                    ValueGUI.this.notify();
                }
            }
        });
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(ok);
        panel.add(skip);
        panel.add(auto);
        pane.add((Component)panel, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    protected abstract String createValueLabel();

    protected abstract JComponent createValueComponent();

    protected abstract Object value();

    public Object next() {
        this.observed = false;
        this.setVisible(true);
        return this.value;
    }

    public static void setNimbus() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

