/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.gui.manualdrive;

import java.awt.Color;
import java.awt.HeadlessException;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import osmo.tester.gui.manualdrive.ValueGUI;
import osmo.tester.model.data.DataType;
import osmo.tester.model.data.SearchableInput;
import osmo.tester.model.data.ValueRange;

public class ValueRangeGUI
extends ValueGUI {
    private JTextArea area;

    public ValueRangeGUI(SearchableInput input) throws HeadlessException {
        super(input);
        this.pack();
    }

    @Override
    protected String createValueLabel() {
        ValueRange range = (ValueRange)this.input;
        return "Give value (range [" + range.min() + " - " + range.max() + "])";
    }

    @Override
    protected JComponent createValueComponent() {
        this.area = new JTextArea();
        return this.area;
    }

    public static void main(String[] args) {
        ValueRange range = new ValueRange(1, 100);
        range.enableGUI();
        System.out.println(range.random());
    }

    @Override
    protected Object value() {
        ValueRange range = (ValueRange)this.input;
        DataType type = range.getType();
        String parseMe = this.area.getText();
        try {
            switch (type) {
                case INT: {
                    this.value = Integer.parseInt(parseMe);
                    break;
                }
                case LONG: {
                    this.value = Long.parseLong(parseMe);
                    break;
                }
                case DOUBLE: {
                    this.value = Double.parseDouble(parseMe);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Enum type:" + (Object)((Object)type) + " unsupported.");
                }
            }
        }
        catch (NumberFormatException ne) {
            this.area.setBackground(Color.RED);
            return null;
        }
        return this.value;
    }
}

