/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.gui.manualdrive;

import java.awt.Color;
import java.awt.HeadlessException;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import osmo.tester.gui.manualdrive.ValueGUI;
import osmo.tester.model.data.DataType;
import osmo.tester.model.data.SearchableInput;
import osmo.tester.model.data.ValueRangeSet;

public class ValueRangeSetGUI
extends ValueGUI {
    private JTextArea area;

    public ValueRangeSetGUI(SearchableInput input) throws HeadlessException {
        super(input);
        this.pack();
    }

    @Override
    protected String createValueLabel() {
        return "Give value (number)";
    }

    @Override
    protected JComponent createValueComponent() {
        this.area = new JTextArea();
        return this.area;
    }

    @Override
    protected Object value() {
        ValueRangeSet range = (ValueRangeSet)this.input;
        DataType type = range.getPartition(0).getType();
        String parseMe = this.area.getText();
        try {
            switch (type) {
                case INT: {
                    this.value = Integer.parseInt(parseMe);
                    break;
                }
                case LONG: {
                    this.value = Long.parseLong(parseMe);
                    break;
                }
                case DOUBLE: {
                    this.value = Double.parseDouble(parseMe);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Enum type:" + (Object)((Object)type) + " unsupported.");
                }
            }
        }
        catch (NumberFormatException e) {
            this.area.setBackground(Color.RED);
            return null;
        }
        return this.value;
    }

    public static void main(String[] args) {
        ValueRangeSetGUI gui = new ValueRangeSetGUI(new ValueRangeSet());
        gui.setVisible(true);
    }
}

