/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import osmo.common.log.Logger;
import osmo.tester.model.CoverageMethod;
import osmo.tester.model.FSMGuard;
import osmo.tester.model.FSMTransition;
import osmo.tester.model.InvocationTarget;
import osmo.tester.model.Requirements;
import osmo.tester.model.TransitionName;
import osmo.tester.model.VariableField;

public class FSM {
    private static final Logger log = new Logger(FSM.class);
    private Map<TransitionName, FSMTransition> transitions = new LinkedHashMap<TransitionName, FSMTransition>();
    private List<FSMGuard> specificGuards = new ArrayList<FSMGuard>();
    private Collection<InvocationTarget> genericGuards = new ArrayList<InvocationTarget>();
    private List<FSMGuard> negatedGuards = new ArrayList<FSMGuard>();
    private Collection<InvocationTarget> genericPre = new ArrayList<InvocationTarget>();
    private Collection<InvocationTarget> genericPost = new ArrayList<InvocationTarget>();
    private List<FSMGuard> specificPre = new ArrayList<FSMGuard>();
    private List<FSMGuard> specificPost = new ArrayList<FSMGuard>();
    private Collection<InvocationTarget> beforeTests = new ArrayList<InvocationTarget>();
    private Collection<InvocationTarget> afterTests = new ArrayList<InvocationTarget>();
    private Collection<InvocationTarget> lastSteps = new ArrayList<InvocationTarget>();
    private Collection<InvocationTarget> beforeSuites = new ArrayList<InvocationTarget>();
    private Collection<InvocationTarget> afterSuites = new ArrayList<InvocationTarget>();
    private Collection<InvocationTarget> endConditions = new ArrayList<InvocationTarget>();
    private Collection<InvocationTarget> explorationEnablers = new ArrayList<InvocationTarget>();
    private Collection<InvocationTarget> generationEnablers = new ArrayList<InvocationTarget>();
    private Collection<VariableField> modelVariables = new ArrayList<VariableField>();
    private Requirements requirements = null;
    private Collection<CoverageMethod> coverageValues = new ArrayList<CoverageMethod>();
    public static final String START_STEP_NAME = ".osmo.tester.start.step";

    public FSMTransition createTransition(TransitionName name, int weight) {
        log.d("Creating transition: " + name + " weight:" + weight);
        FSMTransition transition = this.transitions.get(name);
        if (transition != null) {
            transition.setWeight(weight);
            return transition;
        }
        transition = new FSMTransition(name);
        transition.setWeight(weight);
        this.transitions.put(name, transition);
        log.d("Transition created");
        return transition;
    }

    public void checkFSM(String errors) {
        log.d("Checking FSM validity");
        if (this.transitions.size() == 0) {
            errors = errors + "No test steps found in given model object. Model cannot be processed.\n";
        }
        ArrayList<String> transitionNames = new ArrayList<String>();
        ArrayList<String> groupNames = new ArrayList<String>();
        for (FSMTransition transition : this.transitions.values()) {
            InvocationTarget target = transition.getTransition();
            TransitionName name = transition.getName();
            log.d("Checking test step:" + name);
            if (target == null) {
                errors = errors + "Test step without invocation target" + name + "\n";
                log.d("Error: Found transition without invocation target - " + name);
            }
            errors = this.addGenericElements(transition, errors);
            errors = this.addSpecificGuards(transition, errors);
            errors = this.addSpecificPrePosts(transition, errors);
            errors = this.addNegatedGuards(transition, errors);
            transition.sort();
            transitionNames.add(transition.getStringName());
            String groupName = transition.getGroupName().toString();
            if (groupName.length() <= 0) continue;
            groupNames.add(groupName);
        }
        errors = this.checkGuards(this.specificGuards, errors, "@Guard");
        errors = this.checkGuards(this.negatedGuards, errors, "Negation");
        errors = this.checkGuards(this.specificPre, errors, "@Pre");
        errors = this.checkGuards(this.specificPost, errors, "@Post");
        for (String groupName : groupNames) {
            if (!transitionNames.contains(groupName)) continue;
            errors = errors + "Group name same as a step name (" + groupName + "). Must be different.\n";
        }
        if (errors.length() > 0) {
            throw new IllegalStateException("Invalid test model:\n" + errors);
        }
        log.d("FSM checked");
    }

    private String checkGuards(List<FSMGuard> guards, String errors, String errorMsg) {
        for (FSMGuard guard : guards) {
            if (guard.getCount() != 0) continue;
            TransitionName name = guard.getName();
            if (name.toString().length() == 0) {
                return errors;
            }
            errors = errors + errorMsg + " without matching step:" + name + ".\n";
        }
        return errors;
    }

    private String addGenericElements(FSMTransition step, String errors) {
        for (InvocationTarget guard : this.genericGuards) {
            step.addGuard(guard);
        }
        for (InvocationTarget pre : this.genericPre) {
            step.addPre(pre);
        }
        for (InvocationTarget post : this.genericPost) {
            step.addPost(post);
        }
        return errors;
    }

    private String addSpecificGuards(FSMTransition transition, String errors) {
        TransitionName name = transition.getName();
        TransitionName groupName = transition.getGroupName();
        for (FSMGuard guard : this.specificGuards) {
            TransitionName guardName = guard.getName();
            if (!name.equals(guardName) && !groupName.equals(guardName)) continue;
            log.d("Adding guard " + guardName + " to transition " + name);
            transition.addGuard(guard.getTarget());
            guard.found();
        }
        return errors;
    }

    private String addSpecificPrePosts(FSMTransition transition, String errors) {
        TransitionName name = transition.getName();
        TransitionName groupName = transition.getGroupName();
        for (FSMGuard pre : this.specificPre) {
            TransitionName preName = pre.getName();
            if (!name.equals(preName) && !groupName.equals(preName)) continue;
            log.d("Adding pre " + preName + " to transition " + name);
            transition.addPre(pre.getTarget());
            pre.found();
        }
        for (FSMGuard post : this.specificPost) {
            TransitionName postName = post.getName();
            if (!name.equals(postName) && !groupName.equals(postName)) continue;
            log.d("Adding post " + postName + " to transition " + name);
            transition.addPost(post.getTarget());
            post.found();
        }
        return errors;
    }

    private String addNegatedGuards(FSMTransition transition, String errors) {
        TransitionName name = transition.getName();
        TransitionName groupName = transition.getGroupName();
        for (FSMGuard guard : this.negatedGuards) {
            TransitionName guardName = guard.getName();
            if (!name.shouldNegationApply(guardName) && !groupName.shouldNegationApply(guardName)) continue;
            log.d("Adding negated guard " + guardName + " to transition " + name);
            transition.addGuard(guard.getTarget());
            guard.found();
        }
        return errors;
    }

    public FSMTransition getTransition(TransitionName name) {
        return this.transitions.get(name);
    }

    public FSMTransition getTransition(String name) {
        for (TransitionName tName : this.transitions.keySet()) {
            if (!tName.toString().equals(name)) continue;
            return this.transitions.get(tName);
        }
        return null;
    }

    public Collection<FSMTransition> getTransitions() {
        return this.transitions.values();
    }

    public void addAfter(InvocationTarget target) {
        this.afterTests.add(target);
    }

    public void addBefore(InvocationTarget target) {
        this.beforeTests.add(target);
    }

    public void addAfterSuite(InvocationTarget target) {
        this.afterSuites.add(target);
    }

    public void addBeforeSuite(InvocationTarget target) {
        this.beforeSuites.add(target);
    }

    public Collection<InvocationTarget> getBeforeTests() {
        return this.beforeTests;
    }

    public Collection<InvocationTarget> getAfterTests() {
        return this.afterTests;
    }

    public Collection<InvocationTarget> getBeforeSuites() {
        return this.beforeSuites;
    }

    public Collection<InvocationTarget> getAfterSuites() {
        return this.afterSuites;
    }

    public Collection<InvocationTarget> getEndConditions() {
        return this.endConditions;
    }

    public void addGenericGuard(InvocationTarget target) {
        this.genericGuards.add(target);
    }

    public void addSpecificPre(TransitionName name, InvocationTarget target) {
        this.specificPre.add(new FSMGuard(name, target));
    }

    public void addGenericPre(InvocationTarget target) {
        this.genericPre.add(target);
    }

    public void addGenericPost(InvocationTarget target) {
        this.genericPost.add(target);
    }

    public void addSpecificPost(TransitionName name, InvocationTarget target) {
        this.specificPost.add(new FSMGuard(name, target));
    }

    public void addEndCondition(InvocationTarget target) {
        this.endConditions.add(target);
    }

    public void addModelVariable(VariableField var) {
        this.modelVariables.add(var);
    }

    public void addLastStep(InvocationTarget lastStep) {
        this.lastSteps.add(lastStep);
    }

    public Collection<InvocationTarget> getLastSteps() {
        return this.lastSteps;
    }

    public Collection<VariableField> getModelVariables() {
        return this.modelVariables;
    }

    public Requirements getRequirements() {
        return this.requirements;
    }

    public void setRequirements(Requirements requirements) {
        this.requirements = requirements;
    }

    public void addSpecificGuard(TransitionName name, InvocationTarget target) {
        FSMGuard sg = new FSMGuard(name, target);
        this.specificGuards.add(sg);
    }

    public void addNegatedGuard(TransitionName name, InvocationTarget target) {
        FSMGuard ng = new FSMGuard(name, target);
        this.negatedGuards.add(ng);
    }

    public void addExplorationEnabler(InvocationTarget target) {
        this.explorationEnablers.add(target);
    }

    public void addGenerationEnabler(InvocationTarget target) {
        this.generationEnablers.add(target);
    }

    public Collection<InvocationTarget> getExplorationEnablers() {
        return this.explorationEnablers;
    }

    public Collection<InvocationTarget> getGenerationEnablers() {
        return this.generationEnablers;
    }

    public void addCoverageMethod(CoverageMethod coverageMethod) {
        this.coverageValues.add(coverageMethod);
    }

    public Collection<CoverageMethod> getCoverageMethods() {
        return this.coverageValues;
    }
}

