/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import osmo.common.log.Logger;
import osmo.tester.model.InvocationTarget;
import osmo.tester.model.TransitionName;

public class FSMTransition
implements Comparable<FSMTransition> {
    private static final Logger log = new Logger(FSMTransition.class);
    private final TransitionName name;
    private int weight = 10;
    private final List<InvocationTarget> guards = new ArrayList<InvocationTarget>();
    private InvocationTarget transition = null;
    private final List<InvocationTarget> pres = new ArrayList<InvocationTarget>();
    private final List<InvocationTarget> posts = new ArrayList<InvocationTarget>();
    private TransitionName groupName;

    public FSMTransition(String name) {
        this.name = new TransitionName("", name);
    }

    public FSMTransition(TransitionName name) {
        this.name = name;
    }

    public void sort() {
        Collections.sort(this.pres);
        Collections.sort(this.posts);
        Collections.sort(this.guards);
    }

    public void setGroupName(TransitionName groupName) {
        this.groupName = groupName;
    }

    public void addGuard(InvocationTarget target) {
        this.guards.add(target);
    }

    public void addPre(InvocationTarget target) {
        this.pres.add(target);
    }

    public void addPost(InvocationTarget target) {
        this.posts.add(target);
    }

    public TransitionName getName() {
        return this.name;
    }

    public TransitionName getGroupName() {
        return this.groupName;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public Collection<InvocationTarget> getGuards() {
        return this.guards;
    }

    public InvocationTarget getTransition() {
        return this.transition;
    }

    public void setTransition(InvocationTarget transition) {
        this.transition = transition;
    }

    public Collection<InvocationTarget> getPreMethods() {
        return this.pres;
    }

    public Collection<InvocationTarget> getPostMethods() {
        return this.posts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FSMTransition that = (FSMTransition)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return "FSMTransition{name='" + this.name + '\'' + ", weight=" + this.weight + '}';
    }

    public String getStringName() {
        return this.name.toString();
    }

    @Override
    public int compareTo(FSMTransition o) {
        return this.name.toString().compareTo(o.name.toString());
    }

    public String getModelObjectName() {
        return FSMTransition.createModelObjectName(this.name.getPrefix(), this.transition.getModelObject().getClass());
    }

    public static String createModelObjectName(String prefix, Class modelClass) {
        String className = modelClass.getName();
        if (prefix != null && prefix.length() > 0) {
            return prefix + "-" + className;
        }
        return className;
    }
}

