/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.model;

import java.lang.reflect.Method;
import osmo.common.OSMOException;
import osmo.common.log.Logger;
import osmo.tester.parser.ParserParameters;

public class InvocationTarget
implements Comparable<InvocationTarget> {
    private static final Logger log = new Logger(InvocationTarget.class);
    private final Object modelObject;
    private final Method method;
    private final String type;
    private String description = "";

    public InvocationTarget(ParserParameters parameters, Class type) {
        this.modelObject = parameters.getModel();
        this.method = parameters.getMethod();
        this.type = "@" + type.getName();
        log.d("Found and created " + this.type + " method:" + this.method.getName());
    }

    public Object invoke() {
        try {
            return this.method.invoke(this.modelObject, new Object[0]);
        }
        catch (Exception e) {
            throw new OSMOException("Failed to invoke " + this.type + " method on the model object.", e);
        }
    }

    public Object invoke(Object arg) {
        try {
            return this.method.invoke(this.modelObject, arg);
        }
        catch (Exception e) {
            throw new OSMOException("Failed to invoke " + this.type + " method on the model object.", e);
        }
    }

    public Object getModelObject() {
        return this.modelObject;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvocationTarget that = (InvocationTarget)o;
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        if (this.modelObject != null ? !this.modelObject.equals(that.modelObject) : that.modelObject != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.modelObject != null ? this.modelObject.hashCode() : 0;
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(InvocationTarget o) {
        return this.method.getName().compareTo(o.method.getName());
    }
}

