/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import osmo.common.log.Logger;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.generator.testsuite.TestSuite;

public class Requirements {
    private static final Logger log = new Logger(Requirements.class);
    private List<String> reqs = new ArrayList<String>();
    private Collection<String> covered = new ArrayList<String>();
    private TestSuite testSuite = null;

    public void setTestSuite(TestSuite testSuite) {
        log.d("Setting test suite:" + testSuite);
        this.testSuite = testSuite;
        this.fillCoverage(testSuite.getCoverage());
    }

    public void fillCoverage(TestCoverage tc) {
        this.covered.clear();
        this.covered.addAll(tc.getRequirements());
    }

    public void add(Object requirement) {
        String name;
        if (requirement == null) {
            log.w("NULL value given as requirement. Is that intended?");
        }
        if (this.reqs.contains(name = "" + requirement)) {
            throw new IllegalArgumentException("Attempted to register '" + name + "' twice. Duplicates not allowed.");
        }
        this.reqs.add(name);
    }

    public void covered(Object requirement) {
        if (requirement == null) {
            log.w("NULL value given as requirement. Is that intended?");
        }
        String name = "" + requirement;
        this.covered.add(name);
        this.testSuite.coveredRequirement(name);
    }

    public Collection<String> getRequirements() {
        return this.reqs;
    }

    public Collection<String> getUniqueCoverage() {
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(this.covered);
        return set;
    }

    public Collection<String> getMissingCoverage() {
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(this.reqs);
        set.removeAll(this.covered);
        return set;
    }

    public Collection<String> getFullCoverage() {
        return this.covered;
    }

    public Collection<String> getExcess() {
        LinkedHashSet<String> excess = new LinkedHashSet<String>();
        excess.addAll(this.covered);
        excess.removeAll(this.reqs);
        return excess;
    }

    public boolean isCovered(String requirement) {
        return this.covered.contains(requirement);
    }

    public void clearCoverage() {
        this.covered.clear();
    }

    public String printCoverage() {
        if (this.reqs.size() == 0 && this.covered.size() == 0) {
            return "No requirements defined. Not calculating or showing requirement coverage. \nIf you want to see requirement coverage you need to define a @RequirementsField\nand add some requirements and their coverage into the model.";
        }
        String result = "";
        Collections.sort(this.reqs);
        result = result + "Requirements:" + this.reqs + "\n";
        Collection<String> uniqueCoverage = this.getUniqueCoverage();
        result = result + "Covered:" + uniqueCoverage + "\n";
        result = result + "Not covered:" + this.getMissingCoverage() + "\n";
        int n = uniqueCoverage.size() - this.getExcess().size();
        int total = this.reqs.size();
        if (total > 0) {
            double p = (double)n / (double)total * 100.0;
            MessageFormat format = new MessageFormat("Total unique requirements = {0}/{1} ({2}%) requirements.");
            Object[] args = new Object[]{n, total, p};
            result = result + format.format(args);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.reqs.size() == 0 && this.covered.size() == 0;
    }

    public String toString() {
        return "Requirements{reqs=" + this.reqs + '}';
    }
}

