/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.model;

public class TransitionName {
    private final String prefix;
    private final String name;

    public TransitionName(String prefix, String name) {
        this.prefix = prefix;
        this.name = name;
    }

    public int length() {
        return this.toString().length();
    }

    public String toString() {
        return this.prefix + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransitionName that = (TransitionName)o;
        if (this.name.length() == 0) {
            return false;
        }
        if (this.name != null ? !this.name.equalsIgnoreCase(that.name) : that.name != null) {
            return false;
        }
        return !(this.prefix != null ? !this.prefix.equalsIgnoreCase(that.prefix) : that.prefix != null);
    }

    public int hashCode() {
        int result = this.prefix != null ? this.prefix.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public boolean shouldNegationApply(TransitionName negationName) {
        if (!this.prefix.equalsIgnoreCase(negationName.prefix)) {
            return false;
        }
        if (this.name.length() == 0) {
            return false;
        }
        return !negationName.name.equalsIgnoreCase(this.name);
    }

    public String getPrefix() {
        return this.prefix;
    }
}

