/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.model;

import java.lang.reflect.Field;
import osmo.common.log.Logger;
import osmo.tester.model.VariableValue;
import osmo.tester.model.data.SearchableInput;

public class VariableField {
    private static final Logger log = new Logger(VariableField.class);
    private final Object modelObject;
    private final Field field;
    private final String name;
    private VariableValue variable = null;

    public VariableField(Object modelObject, Field field, String name) {
        this.modelObject = modelObject;
        this.field = field;
        if (name.equals("")) {
            name = field.getName();
        }
        this.name = name;
        this.checkIfVariableValue();
    }

    private void checkIfVariableValue() {
        for (Class<?> type = this.field.getType(); type != null; type = type.getSuperclass()) {
            Class<?>[] interfaces;
            this.checkVariableType(type);
            for (Class<?> i : interfaces = type.getInterfaces()) {
                this.checkVariableType(i);
            }
        }
    }

    private void checkVariableType(Class clazz) {
        if (clazz == VariableValue.class) {
            try {
                this.variable = (VariableValue)this.field.get(this.modelObject);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to read @Variable instance for field:" + this.field, e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        if (this.variable != null) {
            return this.variable.value();
        }
        try {
            return this.field.get(this.modelObject);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to read state variable value for field:" + this.field, e);
        }
    }

    public boolean isSearchableInput() {
        try {
            return this.field.get(this.modelObject) instanceof SearchableInput;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to read state variable value for field:" + this.field, e);
        }
    }

    public String toString() {
        return "VariableField{name='" + this.name + '\'' + '}';
    }
}

