/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.model.data;

import java.util.List;
import osmo.tester.model.data.DataType;
import osmo.tester.model.data.ValueSet;

public class Boundary {
    private ValueSet<Number> validValues = new ValueSet();
    private ValueSet<Number> invalidValues = new ValueSet();
    private int count = 5;
    private Number increment = 1;
    private final DataType type;
    private final Number min;
    private final Number max;

    public Boundary(DataType type, Number min, Number max) {
        this.type = type;
        this.min = min;
        this.max = max;
        this.validValues.setSeed(1L);
        this.invalidValues.setSeed(1L);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Boundary count must be >= 1, was given " + count);
        }
        this.count = count;
    }

    public Number getIncrement() {
        return this.increment;
    }

    public void setIncrement(Number increment) {
        this.increment = increment;
    }

    private void init() {
        Number addReduce = this.increment;
        switch (this.type) {
            case DOUBLE: {
                this.validValues.add(this.min.doubleValue());
                this.validValues.add(this.max.doubleValue());
                break;
            }
            default: {
                this.validValues.add(this.min);
                this.validValues.add(this.max);
            }
        }
        block8: for (int i = 0; i < this.count; ++i) {
            switch (this.type) {
                case INT: {
                    this.validValues.add(this.min.intValue() + addReduce.intValue());
                    this.validValues.add(this.max.intValue() - addReduce.intValue());
                    this.invalidValues.add(this.max.intValue() + addReduce.intValue());
                    this.invalidValues.add(this.min.intValue() - addReduce.intValue());
                    addReduce = addReduce.intValue() + this.increment.intValue();
                    continue block8;
                }
                case LONG: {
                    this.validValues.add(this.min.longValue() + addReduce.longValue());
                    this.validValues.add(this.max.longValue() - addReduce.longValue());
                    this.invalidValues.add(this.max.longValue() + addReduce.longValue());
                    this.invalidValues.add(this.min.longValue() - addReduce.longValue());
                    addReduce = addReduce.longValue() + this.increment.longValue();
                    continue block8;
                }
                case DOUBLE: {
                    this.validValues.add(this.min.doubleValue() + addReduce.doubleValue());
                    this.validValues.add(this.max.doubleValue() - addReduce.doubleValue());
                    this.invalidValues.add(this.max.doubleValue() + addReduce.doubleValue());
                    this.invalidValues.add(this.min.doubleValue() - addReduce.doubleValue());
                    addReduce = addReduce.doubleValue() + this.increment.doubleValue();
                }
            }
        }
    }

    public List<Number> getOptions(boolean in) {
        if (!in) {
            return this.invalidValues.getOptions();
        }
        return this.validValues.getOptions();
    }

    public Number in() {
        if (this.validValues.size() == 0) {
            this.init();
        }
        return this.validValues.loop();
    }

    public Number out() {
        if (this.validValues.size() == 0) {
            this.init();
        }
        return this.invalidValues.loop();
    }
}

