/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.model.data;

import java.util.ArrayList;
import java.util.Collection;
import osmo.tester.model.data.SearchableInput;

public class CharSet
extends SearchableInput<Character> {
    private String validChars = "abcdefghijklmnopqrstuvwxyz\u00e5\u00e4\u00f6ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c5\u00c4\u00d60123456789,.<>!\"#%&/()=?\u00b4`{[]}\\\u00a8^~';:|-_*-+= ";
    private String invalidChars = "";
    private int loopIndex = 0;

    public CharSet() {
        int i;
        for (i = 0; i <= 32; ++i) {
            this.invalidChars = this.invalidChars + (char)i;
        }
        for (i = 127; i <= 258; ++i) {
            this.invalidChars = this.invalidChars + (char)i;
        }
    }

    public void reduceBy(String charsToRemove) {
        char[] array;
        char[] r = charsToRemove.toCharArray();
        String result = "";
        String removed = "";
        for (char c : array = this.validChars.toCharArray()) {
            boolean found = false;
            for (char rc : r) {
                if (c != rc) continue;
                found = true;
                break;
            }
            if (!found) {
                result = result + c;
                continue;
            }
            removed = removed + c;
        }
        this.validChars = result;
        this.invalidChars = this.invalidChars + removed;
    }

    public Character random() {
        int min = 0;
        int max = this.validChars.length() - 1;
        int index = this.rand.nextInt(min, max);
        return Character.valueOf(this.validChars.charAt(index));
    }

    public Character loop() {
        char c = this.validChars.charAt(this.loopIndex);
        ++this.loopIndex;
        if (this.loopIndex >= this.validChars.length()) {
            this.loopIndex = 0;
        }
        return Character.valueOf(c);
    }

    public Character invalidRandom() {
        int min = 0;
        int max = this.invalidChars.length() - 1;
        int index = this.rand.nextInt(min, max);
        return Character.valueOf(this.invalidChars.charAt(index));
    }

    public Character invalidLoop() {
        ++this.loopIndex;
        if (this.loopIndex >= this.invalidChars.length()) {
            this.loopIndex = 0;
        }
        return Character.valueOf(this.invalidChars.charAt(this.loopIndex));
    }

    public boolean evaluate(char c) {
        return this.validChars.indexOf(c) >= 0;
    }

    public CharSet enableXml() {
        this.reduceBy("<>");
        return this;
    }

    public CharSet asciiLettersAndNumbersOnly() {
        this.validChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        this.invalidChars = this.invalidChars + "\u00e5\u00e4\u00f6\u00c5\u00c4\u00d6,.<>!\"#%&/()=?\u00b4`{[]}\\\u00a8^~';:|-_*-+= ";
        return this;
    }

    public CharSet numbersOnly() {
        this.validChars = "0123456789";
        this.invalidChars = this.invalidChars + "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\u00e5\u00e4\u00f6\u00c5\u00c4\u00d6,.<>!\"#%&/()=?\u00b4`{[]}\\\u00a8^~';:|-_*-+= ";
        return this;
    }

    public CharSet custom(String validChars) {
        this.validChars = validChars;
        return this;
    }

    @Override
    public Collection<Character> getOptions() {
        char[] temp;
        ArrayList<Character> result = new ArrayList<Character>();
        for (char c : temp = this.validChars.toCharArray()) {
            result.add(Character.valueOf(c));
        }
        return result;
    }

    @Override
    public void enableGUI() {
    }
}

