/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.model.data;

import java.util.Collection;
import osmo.common.Randomizer;
import osmo.common.log.Logger;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.gui.manualdrive.ValueGUI;
import osmo.tester.model.VariableValue;

public abstract class SearchableInput<T>
implements VariableValue<T> {
    private static final Logger log = new Logger(SearchableInput.class);
    private String name;
    protected ValueGUI gui = null;
    private T latestValue = null;
    private TestSuite suite = null;
    private boolean checked = false;
    private boolean stored = false;
    protected Randomizer rand = null;

    protected SearchableInput() {
    }

    public void setSeed(long seed) {
        this.rand = new Randomizer(seed);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setStored(boolean stored) {
        this.stored = stored;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public void setSuite(TestSuite suite) {
        this.suite = suite;
    }

    @Override
    public T value() {
        return this.getLatestValue();
    }

    public T getLatestValue() {
        return this.latestValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void record(T value) {
        this.latestValue = value;
        if (this.name == null) {
            return;
        }
        if (this.suite == null) {
            return;
        }
        if (!this.stored) {
            return;
        }
        this.suite.addValue(this.name, "" + value);
    }

    public Collection<?> getOptions() {
        throw new UnsupportedOperationException("This variable type does not support defining options");
    }

    public abstract void enableGUI();

    public void disableGUI() {
        this.gui = null;
    }
}

