/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.model.data;

import java.util.ArrayList;
import java.util.Collection;
import osmo.common.log.Logger;
import osmo.tester.gui.manualdrive.TextGUI;
import osmo.tester.model.data.CharSet;
import osmo.tester.model.data.SearchableInput;

public class Text
extends SearchableInput<String> {
    private static final Logger log = new Logger(Text.class);
    private int min = 5;
    private int max = 10;
    private final CharSet chars = new CharSet();
    private Collection<String> history = new ArrayList<String>();
    private boolean invalid = false;
    private int previousLength = -1;
    private int minOffset = 1;
    private int maxOffset = 5;
    private boolean zeroSize = false;
    private boolean zeroDone = false;
    private float invalidProbability = 0.5f;
    private boolean randomToString = false;

    public Text() {
    }

    public Text(int min, int max) {
        this.min = min;
        this.max = max;
        this.checkMinMax(min, max);
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        this.chars.setSeed(seed);
    }

    public Text setInvalidProbability(float invalidProbability) {
        if (invalidProbability < 0.0f || invalidProbability > 1.0f) {
            throw new IllegalArgumentException("Probability must be between 0-1, was " + invalidProbability);
        }
        this.invalidProbability = invalidProbability;
        return this;
    }

    public Text enableZeroSize(boolean zeroSize) {
        this.zeroSize = zeroSize;
        return this;
    }

    private void checkMinMax(int min, int max) {
        if (min < 0 || max < 0) {
            throw new IllegalArgumentException("Minimum and maximum length are not allowed to be negative (was " + min + ", " + max + ")");
        }
        if (max < min) {
            throw new IllegalArgumentException("Maximum length is not allowed to be less than minimum length.");
        }
        if (max == 0) {
            throw new IllegalArgumentException("Min and max are zero - generating/evaluating empty strings makes no sense.");
        }
    }

    public void setOffset(int min, int max) {
        this.minOffset = min;
        this.maxOffset = max;
        this.checkMinMax(min, max);
    }

    private int length() {
        int length = -1;
        if (!this.invalid) {
            length = this.rand.nextInt(this.min, this.max);
        } else {
            if (this.zeroSize && !this.zeroDone) {
                log.d("Giving zero length");
                this.zeroDone = true;
                this.previousLength = 0;
                return 0;
            }
            int offset = this.rand.nextInt(this.minOffset, this.maxOffset);
            length = this.previousLength < this.min ? this.max + offset : this.min - offset;
            if (length < 0) {
                length = 0;
            }
        }
        this.previousLength = length;
        return length;
    }

    public String random() {
        if (this.rand == null) {
            throw new IllegalStateException("You need to set seed before using data objects");
        }
        int length = this.length();
        char[] c = new char[length];
        for (int i = 0; i < length; ++i) {
            c[i] = this.chars.random().charValue();
        }
        String next = new String(c);
        this.history.add(next);
        this.record(next);
        return next;
    }

    public String randomInvalid() {
        if (this.rand == null) {
            throw new IllegalStateException("You need to set seed before using data objects");
        }
        int length = this.length();
        char[] c = new char[length];
        for (int i = 0; i < length; ++i) {
            float f = this.rand.nextFloat(0.0f, 1.0f);
            c[i] = f > this.invalidProbability ? this.chars.random().charValue() : this.chars.invalidRandom().charValue();
        }
        String next = new String(c);
        this.history.add(next);
        this.record(next);
        return next;
    }

    public Text enableXml() {
        this.chars.enableXml();
        return this;
    }

    public Text asciiLettersAndNumbersOnly() {
        this.chars.asciiLettersAndNumbersOnly();
        return this;
    }

    public Text reduceBy(String charsToRemove) {
        this.chars.reduceBy(charsToRemove);
        return this;
    }

    public Collection<String> getHistory() {
        return this.history;
    }

    @Override
    public void enableGUI() {
        if (this.gui != null) {
            return;
        }
        this.gui = new TextGUI(this);
    }

    public Text enableInvalidLength(boolean invalid) {
        this.invalid = invalid;
        return this;
    }

    public Text numbersOnly() {
        this.chars.numbersOnly();
        return this;
    }

    public boolean isRandomToString() {
        return this.randomToString;
    }

    public Text setRandomToString(boolean randomToString) {
        this.randomToString = randomToString;
        return this;
    }

    public String toString() {
        if (this.randomToString) {
            return this.random();
        }
        return super.toString();
    }
}

