/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.model.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.gui.manualdrive.ValueRangeGUI;
import osmo.tester.model.data.Boundary;
import osmo.tester.model.data.DataType;
import osmo.tester.model.data.SearchableInput;
import osmo.tester.model.data.ValueSet;

public class ValueRange<T extends Number>
extends SearchableInput<T> {
    private static final Logger log = new Logger(ValueRange.class);
    private Number min;
    private Number max;
    private Number increment = 1;
    protected List<Number> history = new ArrayList<Number>();
    protected ValueSet<T> balancingChoices = new ValueSet();
    private DataType type;
    private Boundary boundary;
    private Number choice = null;

    public ValueRange(Class<T> type, Number min, Number max) {
        this.min = min;
        this.max = max;
        if (type.equals(Integer.class)) {
            this.setType(DataType.INT);
        } else if (type.equals(Long.class)) {
            this.setType(DataType.LONG);
        } else {
            this.setType(DataType.DOUBLE);
        }
    }

    public ValueRange(Number min, Number max) {
        this.min = min;
        this.max = max;
        if (min instanceof Integer) {
            this.setType(DataType.INT);
        } else if (min instanceof Long) {
            this.setType(DataType.LONG);
        } else {
            this.setType(DataType.DOUBLE);
        }
        this.boundary = new Boundary(this.type, min, max);
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        this.balancingChoices.setSeed(seed);
    }

    private void setType(DataType type) {
        this.type = type;
        this.boundary = new Boundary(this.type, this.min, this.max);
    }

    public DataType getType() {
        return this.type;
    }

    public void setIncrement(Number increment) {
        this.increment = increment;
        this.boundary.setIncrement(increment);
    }

    public void setCount(int count) {
        this.boundary.setCount(count);
    }

    public Number min() {
        return this.min;
    }

    public void setMin(Number min) {
        this.min = min;
    }

    public Number max() {
        return this.max;
    }

    public void setMax(Number max) {
        this.max = max;
    }

    public Collection<Number> getHistory() {
        return this.history;
    }

    private void pre() {
        if (this.rand == null) {
            throw new IllegalStateException("You need to set seed before using data objects");
        }
        this.choice = null;
        OSMOConfiguration.check(this);
        if (this.gui != null) {
            this.choice = (Number)this.gui.next();
        }
    }

    private void post() {
        this.history.add(this.choice);
        this.record(this.choice);
        log.d("Value:" + this.choice);
    }

    public T loop() {
        this.pre();
        if (this.choice == null) {
            Number last = this.min;
            if (this.history.isEmpty()) {
                this.choice = this.min;
                this.post();
                return (T)this.choice;
            }
            last = this.history.get(this.history.size() - 1);
            switch (this.type) {
                case INT: {
                    this.choice = last.intValue() + this.increment.intValue();
                    break;
                }
                case LONG: {
                    this.choice = last.longValue() + this.increment.longValue();
                    break;
                }
                case DOUBLE: {
                    this.choice = last.doubleValue() + this.increment.doubleValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Enum type:" + (Object)((Object)this.type) + " unsupported.");
                }
            }
            if (this.choice.doubleValue() > this.max.doubleValue()) {
                this.choice = this.min;
            }
        }
        this.post();
        return (T)this.choice;
    }

    public T balanced() {
        this.pre();
        if (this.choice == null) {
            if (this.balancingChoices.size() == 0) {
                this.balancingChoices.addAll(this.getOptions());
            }
            this.choice = (Number)this.balancingChoices.removeRandom();
        }
        this.post();
        return (T)this.choice;
    }

    public T random() {
        this.pre();
        if (this.choice == null) {
            switch (this.type) {
                case INT: {
                    this.choice = this.rand.nextInt(this.min().intValue(), this.max().intValue());
                    break;
                }
                case LONG: {
                    this.choice = this.rand.nextLong(this.min().longValue(), this.max().longValue());
                    break;
                }
                case DOUBLE: {
                    this.choice = this.rand.nextDouble(this.min().doubleValue(), this.max().doubleValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Enum type:" + (Object)((Object)this.type) + " unsupported.");
                }
            }
        }
        this.post();
        return (T)this.choice;
    }

    public T boundaryIn() {
        this.pre();
        if (this.choice == null) {
            this.choice = this.boundary.in();
        }
        this.post();
        return (T)this.choice;
    }

    public T boundaryOut() {
        this.pre();
        if (this.choice == null) {
            this.choice = this.boundary.out();
        }
        this.post();
        return (T)this.choice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueRange that = (ValueRange)o;
        if (this.increment != null ? !this.increment.equals(that.increment) : that.increment != null) {
            return false;
        }
        if (this.max != null ? !this.max.equals(that.max) : that.max != null) {
            return false;
        }
        return !(this.min != null ? !this.min.equals(that.min) : that.min != null);
    }

    public int hashCode() {
        int result = this.min != null ? this.min.hashCode() : 0;
        result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
        result = 31 * result + (this.increment != null ? this.increment.hashCode() : 0);
        return result;
    }

    @Override
    public Collection<T> getOptions() {
        int n = (int)Math.round((this.max.doubleValue() - this.min.doubleValue()) / this.increment.doubleValue());
        if (n > 1000) {
            throw new IllegalStateException("Currently only 1000 values in coverage are supported. You request " + n + ".");
        }
        log.d("Number of options:" + n);
        Number min = this.min;
        Number max = this.max;
        ArrayList<Integer> options = new ArrayList<Integer>();
        while (max.doubleValue() >= min.doubleValue()) {
            Number value = null;
            switch (this.type) {
                case INT: {
                    value = new Integer(min.intValue());
                    min = min.intValue() + this.increment.intValue();
                    break;
                }
                case LONG: {
                    value = new Long(min.longValue());
                    min = min.longValue() + this.increment.longValue();
                    break;
                }
                case DOUBLE: {
                    value = new Double(min.doubleValue());
                    min = min.doubleValue() + this.increment.doubleValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Enum type:" + (Object)((Object)this.type) + " unsupported.");
                }
            }
            options.add((Integer)value);
        }
        return options;
    }

    @Override
    public void enableGUI() {
        if (this.gui != null) {
            return;
        }
        this.gui = new ValueRangeGUI(this);
    }

    public String toString() {
        return "ValueRange{ name=" + this.getName() + ", " + "min=" + this.min + ", max=" + this.max + '}';
    }
}

