/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.model.data;

import java.util.Collection;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.gui.manualdrive.ValueRangeSetGUI;
import osmo.tester.model.data.SearchableInput;
import osmo.tester.model.data.ValueRange;
import osmo.tester.model.data.ValueSet;

public class ValueRangeSet<T extends Number>
extends SearchableInput<T> {
    private static final Logger log = new Logger(ValueRangeSet.class);
    private ValueSet<ValueRange<T>> partitions = new ValueSet();
    private int strategy = 1;
    private Number increment = 1;
    private T choice = null;
    public static final int RANDOM = 1;
    public static final int BALANCED = 2;
    public static final int LOOP = 3;

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        this.partitions.setSeed(seed);
        for (ValueRange range : this.partitions.getOptions()) {
            range.setSeed(seed);
        }
    }

    public void setStrategy(int strategy) {
        this.strategy = strategy;
    }

    public ValueRange getPartition(int i) {
        return (ValueRange)this.partitions.getOptions().get(i);
    }

    public void setIncrement(Number increment) {
        Collection all = this.partitions.getOptions();
        for (ValueRange range : all) {
            range.setIncrement(increment);
        }
    }

    public void addPartition(Number min, Number max) {
        log.d("Adding partition min(" + min + ") max(" + max + ")");
        this.validateRange(min, max);
        ValueRange<Number> range = null;
        range = min instanceof Integer ? new ValueRange<Integer>(Integer.class, min, max) : (min instanceof Long ? new ValueRange<Long>(Long.class, min, max) : new ValueRange<Double>(Double.class, min, max));
        range.setIncrement(this.increment);
        range.setSeed(this.rand.getSeed());
        this.partitions.add(range);
    }

    public void addPartition(Class<T> type, Number min, Number max) {
        log.d("Adding partition min(" + min + ") max(" + max + ")");
        this.validateRange(min, max);
        ValueRange<T> range = new ValueRange<T>(type, min, max);
        range.setSeed(this.rand.getSeed());
        this.partitions.add(range);
    }

    private void validateRange(Number min, Number max) {
        if (min.doubleValue() > max.doubleValue()) {
            throw new IllegalArgumentException("Minimum value cannot be greater than maximum value.");
        }
    }

    public void removePartition(double min, double max) {
        log.d("Removing partition min(" + min + ") max(" + max + ")");
        this.partitions.remove(new ValueRange(min, max));
    }

    public ValueRange nextPartition() {
        switch (this.strategy) {
            case 2: {
                return this.partitions.balanced();
            }
            case 3: {
                return this.partitions.loop();
            }
        }
        return this.partitions.random();
    }

    protected void validate() {
        if (this.partitions.size() == 0) {
            throw new IllegalStateException("No partitions defined. Add some to use this for something.");
        }
    }

    private void pre() {
        if (this.rand == null) {
            throw new IllegalStateException("You need to set seed before using data objects");
        }
        this.choice = null;
        if (this.gui != null) {
            this.choice = (Number)this.gui.next();
            return;
        }
        OSMOConfiguration.check(this);
        this.validate();
    }

    private void post() {
        this.record(this.choice);
    }

    public T random() {
        this.pre();
        if (this.choice == null) {
            ValueRange vr = this.nextPartition();
            this.choice = vr.random();
        }
        this.post();
        return this.choice;
    }

    public T ordered() {
        this.pre();
        if (this.choice == null) {
            ValueRange vr = this.nextPartition();
            this.choice = vr.loop();
        }
        this.post();
        return this.choice;
    }

    public T balanced() {
        this.pre();
        if (this.choice == null) {
            ValueRange vr = this.nextPartition();
            this.choice = vr.balanced();
        }
        this.post();
        return this.choice;
    }

    public T boundaryIn() {
        this.pre();
        if (this.choice == null) {
            ValueRange vr = this.nextPartition();
            this.choice = vr.boundaryIn();
        }
        this.post();
        return this.choice;
    }

    public T boundaryOut() {
        this.pre();
        if (this.choice == null) {
            ValueRange vr = this.nextPartition();
            this.choice = vr.boundaryOut();
        }
        this.post();
        return this.choice;
    }

    @Override
    public void enableGUI() {
        if (this.gui != null) {
            return;
        }
        this.gui = new ValueRangeSetGUI(this);
    }

    public String toString() {
        return "ValueRangeSet{partitions=" + this.partitions + '}';
    }
}

