/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.model.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.gui.manualdrive.ValueSetGUI;
import osmo.tester.model.data.SearchableInput;

public class ValueSet<T>
extends SearchableInput<T> {
    private static final Logger log = new Logger(ValueSet.class);
    private List<T> options = new ArrayList<T>();
    private List<T> reserved = new ArrayList<T>();
    private List<T> free = new ArrayList<T>();
    private int next = 0;
    private T choice = null;
    private Collection<T> history = new ArrayList<T>();

    public ValueSet() {
        this.init();
    }

    @SafeVarargs
    public ValueSet(T ... items) {
        for (T item : items) {
            this.add(item);
        }
        this.init();
    }

    private void init() {
    }

    public void add(T option) {
        this.options.add(option);
        this.free.add(option);
    }

    public void addAll(Collection<T> options) {
        this.options.addAll(options);
        this.free.addAll(options);
    }

    public void add(T option, int weight) {
        for (int i = 0; i < weight; ++i) {
            this.options.add(option);
            this.free.add(option);
        }
    }

    public void remove(T option) {
        int index = this.options.indexOf(option);
        if (index < 0) {
            return;
        }
        if (index <= this.next) {
            --this.next;
        }
        this.options.remove(option);
        this.free.remove(option);
        this.reserved.remove(option);
    }

    private void pre() {
        if (this.rand == null) {
            throw new IllegalStateException("You need to set seed before using data objects");
        }
        this.choice = null;
        if (this.gui != null) {
            this.choice = this.gui.next();
            return;
        }
        OSMOConfiguration.check(this);
        if (this.options.isEmpty()) {
            throw new IllegalStateException("No value to provide (add some options).");
        }
    }

    private void post() {
        this.history.add(this.choice);
        this.record(this.choice);
    }

    public T random() {
        this.pre();
        if (this.choice == null) {
            if (this.free.isEmpty()) {
                throw new IllegalStateException("No free to choose from.");
            }
            this.choice = this.rand.oneOf(this.free);
        }
        this.post();
        return this.choice;
    }

    public T randomAny() {
        this.pre();
        if (this.choice == null) {
            this.choice = this.rand.oneOf(this.options);
        }
        this.post();
        return this.choice;
    }

    public T randomReserved() {
        this.pre();
        if (this.choice == null) {
            if (this.reserved.isEmpty()) {
                throw new IllegalStateException("No reserved to choose from.");
            }
            this.choice = this.rand.oneOf(this.reserved);
        }
        this.post();
        return this.choice;
    }

    public void reserve(T t) {
        if (!this.options.contains(t)) {
            throw new IllegalArgumentException("Tried to reserve non-existing option:" + t);
        }
        if (!this.free.contains(t)) {
            throw new IllegalArgumentException("Tried to reserve something that is not free:" + t);
        }
        this.reserved.add(t);
        this.free.remove(t);
    }

    public int reserved() {
        return this.reserved.size();
    }

    public T reserve() {
        this.pre();
        if (this.choice == null) {
            if (this.free.isEmpty()) {
                throw new IllegalStateException("Nothing left to reserve.");
            }
            this.choice = this.rand.oneOf(this.free);
            this.reserved.add(this.choice);
            this.free.remove(this.choice);
        }
        this.post();
        return this.choice;
    }

    public T removeRandom() {
        this.pre();
        if (this.choice == null) {
            this.choice = this.rand.oneOf(this.options);
        }
        this.options.remove(this.choice);
        this.free.remove(this.choice);
        this.reserved.remove(this.choice);
        this.post();
        return this.choice;
    }

    public void free(T option) {
        boolean ok = this.reserved.remove(option);
        if (!ok) {
            throw new IllegalArgumentException("Given option to free that was not reserved:" + option);
        }
        this.free.add(option);
    }

    public int available() {
        return this.free.size();
    }

    public boolean contains(T option) {
        return this.options.contains(option);
    }

    public T balanced() {
        this.pre();
        if (this.choice == null) {
            LinkedHashSet<Object> choices = new LinkedHashSet<Object>();
            choices.addAll(this.free);
            choices.removeAll(this.history);
            if (choices.size() == 0) {
                LinkedHashMap<T, Integer> coverage = new LinkedHashMap<T, Integer>();
                for (T t : this.history) {
                    Integer count = (Integer)coverage.get(t);
                    if (count == null) {
                        count = 0;
                    }
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    coverage.put(t, count);
                }
                int min = (Integer)this.rand.minOf(coverage.values());
                for (Map.Entry item : coverage.entrySet()) {
                    if ((Integer)coverage.get(item.getKey()) != min) continue;
                    choices.add(item.getKey());
                }
            }
            this.choice = this.rand.oneOf(choices);
        }
        this.post();
        return this.choice;
    }

    public T loop() {
        this.pre();
        if (this.choice == null) {
            ArrayList<T> currentOptions = new ArrayList<T>();
            currentOptions.addAll(this.free);
            if (this.next >= currentOptions.size()) {
                this.next = 0;
            }
            this.choice = currentOptions.get(this.next++);
        }
        this.post();
        return this.choice;
    }

    public int size() {
        return this.options.size();
    }

    @Override
    public List<T> getOptions() {
        return this.options;
    }

    public List<T> getFreeOptions() {
        return this.free;
    }

    public List<T> getReservedOptions() {
        return this.reserved;
    }

    @Override
    public void enableGUI() {
        if (this.gui != null) {
            return;
        }
        this.gui = new ValueSetGUI(this);
    }

    public String toString() {
        return "ValueSet{name=" + this.getName() + ", " + "options=" + this.options + '}';
    }

    public void setOptions(Collection<T> newOptions) {
        this.history.clear();
        this.options.clear();
        this.free.clear();
        this.reserved.clear();
        this.options.addAll(newOptions);
        this.free.addAll(newOptions);
    }

    public void clear() {
        this.options.clear();
        this.free.clear();
        this.reserved.clear();
    }

    public long getSeed() {
        return this.rand.getSeed();
    }
}

