/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer;

import java.util.Collection;
import osmo.tester.coverage.ScoreCalculator;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.generator.testsuite.TestCase;

public class CSVCoverageReport {
    private final ScoreCalculator scoreCalculator;
    private String coverage = "cumulative coverage per test\n";
    private String gain = "gained coverage per test\n";
    private String testCount = "number of tests in suite\n";
    private String totalScore = "total score\n";
    private String steps = "number of steps\n";
    private String stepPairs = "number of step pairs\n";
    private String values = "number of values\n";
    private String reqs = "number of requirements\n";
    private String length = "length\n";
    private String states = "number of states:\n";
    private String statePairs = "number of state pairs:\n";

    public CSVCoverageReport(ScoreCalculator scoreCalculator) {
        this.scoreCalculator = scoreCalculator;
    }

    public String report() {
        String report = "";
        report = report + this.coverage;
        report = report + this.gain;
        report = report + this.testCount;
        report = report + this.totalScore;
        report = report + this.steps;
        report = report + this.stepPairs;
        report = report + this.values;
        report = report + this.states;
        report = report + this.statePairs;
        report = report + this.reqs;
        report = report + this.length;
        return report;
    }

    public void process(Collection<TestCase> tests) {
        TestCoverage tc = new TestCoverage();
        for (TestCase test : tests) {
            int old = this.scoreCalculator.calculateScore(tc);
            tc.addCoverage(test.getCoverage());
            int now = this.scoreCalculator.calculateScore(tc);
            int gain = now - old;
            this.gain = this.gain + gain + "; ";
            this.coverage = this.coverage + this.scoreCalculator.calculateScore(tc) + "; ";
            this.reqs = this.reqs + tc.getRequirements().size() + "; ";
            this.length = this.length + tc.getTotalSteps() + "; ";
            this.steps = this.steps + tc.getSingles().size() + "; ";
            this.stepPairs = this.stepPairs + tc.getStepPairs().size() + "; ";
            this.values = this.values + tc.getValueCount() + "; ";
            this.states = this.states + tc.getStateCount() + "; ";
            this.statePairs = this.statePairs + tc.getStatePairCount() + "; ";
        }
        this.gain = this.gain + "\n";
        this.coverage = this.coverage + "\n";
        this.reqs = this.reqs + "\n";
        this.length = this.length + "\n";
        this.steps = this.steps + "\n";
        this.stepPairs = this.stepPairs + "\n";
        this.states = this.states + "\n";
        this.statePairs = this.statePairs + "\n";
        this.values = this.values + "\n";
        this.testCount = this.testCount + tests.size();
        this.testCount = this.testCount + "\n";
        this.totalScore = this.totalScore + this.scoreCalculator.calculateScore(tc);
        this.totalScore = this.totalScore + "\n";
    }
}

