/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.greedy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import osmo.common.TestUtils;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.OSMOTester;
import osmo.tester.coverage.ScoreCalculator;
import osmo.tester.coverage.ScoreConfiguration;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.generator.MainGenerator;
import osmo.tester.generator.SingleInstanceModelFactory;
import osmo.tester.generator.endcondition.EndCondition;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.model.FSM;
import osmo.tester.model.Requirements;
import osmo.tester.optimizer.CSVCoverageReport;
import osmo.tester.optimizer.GenerationResults;
import osmo.tester.optimizer.TestSorter;
import osmo.tester.optimizer.greedy.IterationListener;
import osmo.tester.optimizer.multiosmo.MultiOSMO;

public class GreedyOptimizer {
    private static final Logger log = new Logger(GreedyOptimizer.class);
    private final ScoreConfiguration config;
    private FSM fsm = null;
    private static int nextId = 1;
    public final int id = nextId++;
    private final ScoreCalculator scoreCalculator;
    private int threshold = 1;
    private int maxIterations = 0;
    private long timeout = -1L;
    private Collection<String> possiblePairs = new LinkedHashSet<String>();
    private final OSMOConfiguration osmoConfig;
    private long start = 0L;
    private List<TestCase> suite = new ArrayList<TestCase>();
    private int iteration = 0;
    private String midPath = "";
    private long seed = 0L;
    private int max = 0;
    private Collection<IterationListener> listeners = new HashSet<IterationListener>();
    private boolean subStatus;

    public GreedyOptimizer(OSMOConfiguration osmoConfig, ScoreConfiguration configuration) {
        this.osmoConfig = osmoConfig;
        osmoConfig.setDataTraceRequested(false);
        this.config = configuration;
        this.scoreCalculator = new ScoreCalculator(configuration);
    }

    public void setMidPath(String midPath) {
        this.midPath = midPath;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void enableDataTrace() {
        this.osmoConfig.setDataTraceRequested(true);
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public GenerationResults search(long seed) {
        return this.search(1000, seed);
    }

    public GenerationResults search(int populationSize, long seed) {
        this.check();
        this.seed = seed;
        CSVCoverageReport report = new CSVCoverageReport(this.scoreCalculator);
        MainGenerator generator = this.configure(seed);
        this.generate(report, generator, populationSize);
        this.possiblePairs = generator.getPossibleStepPairs();
        TestCoverage suiteCoverage = new TestCoverage(this.suite);
        this.writeReport(report, suiteCoverage, this.suite.size(), this.iteration * populationSize);
        this.updateRequirementsCoverage(suiteCoverage);
        if (!this.subStatus) {
            for (IterationListener listener : this.listeners) {
                listener.generationDone(this.suite);
            }
        }
        return new GenerationResults(this.suite);
    }

    private void generate(CSVCoverageReport report, MainGenerator generator, int populationSize) {
        this.suite = new ArrayList<TestCase>();
        this.start = System.currentTimeMillis();
        int gain = Integer.MAX_VALUE;
        int previousScore = 0;
        long endTime = -1L;
        if (this.timeout > 0L) {
            endTime = System.currentTimeMillis() + this.timeout * 1000L;
        }
        log.i("greedy " + this.id + " starting up, population size " + populationSize);
        while (this.shouldRun(gain, this.iteration)) {
            long iStart = System.currentTimeMillis();
            log.i(this.id + ":starting iteration " + this.iteration);
            ++this.iteration;
            for (int i = 0; i < populationSize; ++i) {
                log.d("creating test case " + i);
                TestCase testCase = generator.nextTest();
                this.suite.add(testCase);
            }
            log.i(this.id + ":sorting and pruning iteration results");
            this.suite = GreedyOptimizer.sortAndPrune(this.id, this.suite, this.scoreCalculator, this.max);
            report.process(this.suite);
            TestCoverage suiteCoverage = new TestCoverage(this.suite);
            int score = this.scoreCalculator.calculateScore(suiteCoverage);
            gain = score - previousScore;
            previousScore = score;
            for (IterationListener listener : this.listeners) {
                listener.iterationDone(this.suite);
            }
            long diff = System.currentTimeMillis() - iStart;
            log.i(this.id + ":iteration time:(" + this.iteration + ")" + diff + " gain:" + gain);
            if (endTime <= 0L || endTime >= System.currentTimeMillis()) continue;
            log.i("Generation timed out");
            break;
        }
        if (gain < this.threshold) {
            log.i("gain under threshold (" + gain + " vs " + this.threshold + ")");
        }
        generator.endSuite();
    }

    private boolean shouldRun(int gain, int iterations) {
        if (this.maxIterations > 0 && iterations >= this.maxIterations) {
            return false;
        }
        return gain >= this.threshold;
    }

    private void updateRequirementsCoverage(TestCoverage suiteCoverage) {
        Requirements reqs = this.fsm.getRequirements();
        reqs.fillCoverage(suiteCoverage);
    }

    private void check() {
        if (this.osmoConfig.getFactory() instanceof SingleInstanceModelFactory) {
            System.out.println(MultiOSMO.ERROR_MSG);
        }
        if (this.config.getLengthWeight() > 0) {
            log.w("Length weight was defined as > 0, reset to 0.");
            this.config.setLengthWeight(0);
        }
        if (this.threshold < 1) {
            log.w("Threshold is " + this.threshold + ", which is impossible to reach. Are you sure?");
        }
    }

    private MainGenerator configure(long seed) {
        OSMOTester tester = new OSMOTester();
        tester.setConfig(this.osmoConfig);
        MainGenerator generator = tester.initGenerator(seed);
        this.osmoConfig.initialize(seed, tester.getFsm());
        generator.initSuite();
        generator.getSuite().setKeepTests(false);
        this.fsm = generator.getFsm();
        EndCondition endCondition = this.osmoConfig.getTestCaseEndCondition();
        endCondition.init(seed, this.fsm, this.osmoConfig);
        tester.setTestEndCondition(endCondition);
        this.config.validate(this.fsm);
        log.d("greedy configuration validated");
        return generator;
    }

    private void writeReport(CSVCoverageReport report, TestCoverage tc, int resultSize, int generationCount) {
        String summary = "summary\n";
        summary = summary + tc.coverageString(this.fsm, this.possiblePairs, null, null, null, false);
        String totalCsv = report.report();
        totalCsv = totalCsv + summary + "\n";
        TestUtils.write(totalCsv, this.createReportPath());
        long end = System.currentTimeMillis();
        long diff = end - this.start;
        log.i("GreedyOptimizer " + this.id + " generated " + generationCount + " tests.");
        log.i("Resulting suite has " + resultSize + " tests. Generation time " + diff + " millis");
    }

    public String createReportPath() {
        String filename = this.id + "-scores.csv";
        return "osmo-output/" + this.midPath + "greedy-" + this.seed + "/" + filename;
    }

    public static List<TestCase> sortAndPrune(int id, List<TestCase> from, ScoreCalculator calculator, int max) {
        Collections.sort(from, new TestSorter());
        ArrayList<TestCase> suite = new ArrayList<TestCase>();
        for (TestCase test : from) {
            test.cloneCoverage();
        }
        int times = 0;
        TestCase best = null;
        TestCoverage bestCoverage = null;
        while (from.size() > 0) {
            int bestScore = 0;
            TestCase found = null;
            for (TestCase test : from) {
                int score;
                TestCoverage tc = test.getCoverage();
                if (best != null) {
                    tc.removeAll(bestCoverage);
                }
                if ((score = calculator.calculateScore(tc)) > bestScore) {
                    bestScore = score;
                    found = test;
                }
                ++times;
            }
            if (found == null) break;
            best = found;
            bestCoverage = best.getCoverage();
            from.remove(best);
            suite.add(best);
            if (max <= 0 || suite.size() < max) continue;
            break;
        }
        int steps = 0;
        for (TestCase test : from) {
            test.switchToClonedCoverage();
            steps += test.getCoverage().getTotalSteps();
        }
        for (TestCase test : suite) {
            test.switchToClonedCoverage();
            steps += test.getCoverage().getTotalSteps();
        }
        log.i(id + ":loops in sort:" + times + ", tests:" + suite.size() + ", steps:" + steps);
        return suite;
    }

    public FSM getFsm() {
        return this.fsm;
    }

    public Collection<String> getPossiblePairs() {
        return this.possiblePairs;
    }

    public void addIterationListener(IterationListener listener) {
        this.listeners.add(listener);
    }

    public void disableThreshold() {
        this.threshold = Integer.MIN_VALUE;
    }

    public void setSubStatus(boolean subStatus) {
        this.subStatus = subStatus;
    }

    public boolean isSubStatus() {
        return this.subStatus;
    }
}

