/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.greedy;

import java.util.Collection;
import java.util.concurrent.Callable;
import osmo.common.log.Logger;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.optimizer.GenerationResults;
import osmo.tester.optimizer.greedy.GreedyOptimizer;

public class GreedyTask
implements Callable<Collection<TestCase>> {
    private static final Logger log = new Logger(GreedyTask.class);
    private final GreedyOptimizer optimizer;
    private final long seed;
    private final int populationSize;

    public GreedyTask(GreedyOptimizer optimizer, long seed, int populationSize) {
        this.optimizer = optimizer;
        this.seed = seed;
        this.populationSize = populationSize;
    }

    @Override
    public Collection<TestCase> call() throws Exception {
        log.d("Starting task for optimizer:" + this.optimizer);
        GenerationResults result = this.optimizer.search(this.populationSize, this.seed);
        log.d("Finished task for optimizer:" + this.optimizer);
        return result.getTests();
    }
}

