/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.greedy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import osmo.common.Randomizer;
import osmo.common.TestUtils;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.coverage.ScoreCalculator;
import osmo.tester.coverage.ScoreConfiguration;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.model.FSM;
import osmo.tester.model.Requirements;
import osmo.tester.optimizer.CSVCoverageReport;
import osmo.tester.optimizer.greedy.GreedyOptimizer;
import osmo.tester.optimizer.greedy.GreedyTask;
import osmo.tester.optimizer.greedy.IterationListener;

public class MultiGreedy {
    private static final Logger log = new Logger(MultiGreedy.class);
    private final ScoreConfiguration optimizerConfig;
    private final ExecutorService greedyPool;
    private FSM fsm = null;
    private int timeout = -1;
    private final OSMOConfiguration osmoConfig;
    private int populationSize = 1000;
    private Collection<String> possiblePairs = new LinkedHashSet<String>();
    private final ScoreCalculator calculator;
    private final Randomizer rand;
    private int optimizerCount = Runtime.getRuntime().availableProcessors();
    private final List<GreedyOptimizer> optimizers = new ArrayList<GreedyOptimizer>();
    private boolean deleteOldOutput = false;
    private boolean dataTrace = false;
    private TestCoverage finalCoverage = null;
    private final String midPath;
    private int max = 0;
    private int maxIterations = 0;
    private int threshold = 1;
    private final Collection<IterationListener> listeners = new HashSet<IterationListener>();

    public MultiGreedy(OSMOConfiguration osmoConfig, ScoreConfiguration scoreConfig, long seed) {
        this(osmoConfig, scoreConfig, seed, Runtime.getRuntime().availableProcessors());
    }

    public MultiGreedy(OSMOConfiguration osmoConfig, ScoreConfiguration scoreConfig, long seed, int parallelism) {
        this.osmoConfig = osmoConfig;
        this.optimizerConfig = scoreConfig;
        this.calculator = new ScoreCalculator(scoreConfig);
        this.greedyPool = Executors.newFixedThreadPool(parallelism);
        this.rand = new Randomizer(seed);
        this.optimizerCount = parallelism;
        this.midPath = "multi-greedy-" + seed + "/";
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void enableDataTrace() {
        this.dataTrace = true;
    }

    public boolean isDeleteOldOutput() {
        return this.deleteOldOutput;
    }

    public void setDeleteOldOutput(boolean deleteOldOutput) {
        this.deleteOldOutput = deleteOldOutput;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public List<TestCase> search() {
        if (this.deleteOldOutput) {
            TestUtils.recursiveDelete("osmo-output");
        }
        long start = System.currentTimeMillis();
        List<TestCase> tests = this.generate();
        log.i("sorting set from all optimizers");
        tests = GreedyOptimizer.sortAndPrune(-1, tests, this.calculator, this.max);
        tests = this.trimToMax(tests);
        this.writeFinalReport(tests, this.rand.getSeed());
        this.updateRequirements(tests);
        log.i("search done");
        long end = System.currentTimeMillis();
        long seconds = (end - start) / 1000L;
        System.out.println("duration of search: " + seconds + "s.");
        for (IterationListener listener : this.listeners) {
            listener.generationDone(tests);
        }
        return tests;
    }

    private List<TestCase> generate() {
        log.i("Starting search with " + this.optimizerCount + " optimizers");
        ArrayList<Future<Collection<TestCase>>> futures = new ArrayList<Future<Collection<TestCase>>>();
        this.runOptimizers(futures);
        List<TestCase> allTests = this.collectAllTests(futures);
        log.i("optimizers done");
        this.greedyPool.shutdown();
        this.collectReportData();
        return allTests;
    }

    private List<TestCase> trimToMax(List<TestCase> allTests) {
        if (this.max <= 0) {
            return allTests;
        }
        ArrayList<TestCase> tests = new ArrayList<TestCase>();
        for (TestCase test : allTests) {
            tests.add(test);
            if (tests.size() < this.max) continue;
            return tests;
        }
        return tests;
    }

    private void runOptimizers(Collection<Future<Collection<TestCase>>> futures) {
        for (int i = 0; i < this.optimizerCount; ++i) {
            GreedyOptimizer optimizer = new GreedyOptimizer(new OSMOConfiguration(this.osmoConfig), this.optimizerConfig);
            optimizer.setMidPath(this.midPath);
            optimizer.setSubStatus(true);
            if (this.dataTrace) {
                optimizer.enableDataTrace();
            }
            optimizer.setTimeout(this.timeout);
            optimizer.setThreshold(this.threshold);
            optimizer.setMaxIterations(this.maxIterations);
            for (IterationListener listener : this.listeners) {
                optimizer.addIterationListener(listener);
            }
            GreedyTask task = new GreedyTask(optimizer, this.rand.nextLong(), this.populationSize);
            Future<Collection<TestCase>> future = this.greedyPool.submit(task);
            log.d("task submitted to pool");
            futures.add(future);
            this.optimizers.add(optimizer);
        }
    }

    private List<TestCase> collectAllTests(Collection<Future<Collection<TestCase>>> futures) {
        ArrayList<TestCase> allTests = new ArrayList<TestCase>();
        for (Future<Collection<TestCase>> future : futures) {
            try {
                allTests.addAll(future.get());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to run a (Multi) GreedyOptimizer", e);
            }
        }
        return allTests;
    }

    private void collectReportData() {
        for (GreedyOptimizer optimizer : this.optimizers) {
            this.fsm = optimizer.getFsm();
            this.possiblePairs.addAll(optimizer.getPossiblePairs());
        }
    }

    private void updateRequirements(List<TestCase> cases) {
        Requirements reqs = this.fsm.getRequirements();
        TestCoverage coverage = new TestCoverage(cases);
        reqs.fillCoverage(coverage);
    }

    private void writeFinalReport(List<TestCase> cases, long seed) {
        String summary = "summary\n";
        summary = summary + "tests: " + cases.size() + "\n";
        CSVCoverageReport report = new CSVCoverageReport(this.calculator);
        report.process(cases);
        this.finalCoverage = new TestCoverage(cases);
        summary = summary + this.finalCoverage.coverageString(this.fsm, this.possiblePairs, null, null, null, false);
        String totalCsv = report.report();
        totalCsv = totalCsv + summary + "\n";
        String filename = this.createFinalReportPath();
        TestUtils.write(totalCsv, filename);
    }

    public String createFinalReportPath() {
        return "osmo-output/" + this.midPath + "final-scores.csv";
    }

    public FSM getFsm() {
        return this.fsm;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public TestCoverage getFinalCoverage() {
        return this.finalCoverage;
    }

    public void addIterationListener(IterationListener listener) {
        this.listeners.add(listener);
    }
}

