/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.multiosmo;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import osmo.common.Randomizer;
import osmo.tester.OSMOConfiguration;
import osmo.tester.OSMOTester;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.generator.endcondition.Time;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestSuite;

public class GeneratorTask
implements Callable<TestCoverage> {
    private final OSMOConfiguration config;
    private final Randomizer seeder;
    private final Time time;
    private final int id;
    private static volatile int nextId = 1;
    private final boolean traceAll;
    private final boolean printCoverage;

    public GeneratorTask(OSMOConfiguration config, Time time, long seed, boolean traceAll, boolean printCoverage) {
        this.config = config;
        this.seeder = new Randomizer(seed);
        this.time = time;
        this.id = nextId++;
        this.traceAll = traceAll;
        this.printCoverage = printCoverage;
    }

    @Override
    public TestCoverage call() throws Exception {
        TestCoverage tc = new TestCoverage();
        this.time.init(0L, null, this.config);
        int i = 1;
        while (!this.time.endTest(null, null)) {
            OSMOTester tester = new OSMOTester();
            tester.setConfig(this.config);
            tester.setPrintCoverage(this.printCoverage);
            long seed = this.seeder.nextLong();
            tester.generate(seed);
            TestSuite suite = tester.getSuite();
            List<TestCase> tests = suite.getAllTestCases();
            TestCoverage tc2 = new TestCoverage(tests);
            tc.addCoverage(tc2);
            if (this.traceAll) {
                OSMOTester.writeTrace("osmo-output/mosmo-task-" + this.id + "-i-" + i, tests, seed, this.config);
            } else {
                ArrayList<TestCase> failed = new ArrayList<TestCase>();
                for (TestCase test : tests) {
                    if (!test.isFailed()) continue;
                    failed.add(test);
                }
                if (failed.size() > 0) {
                    OSMOTester.writeTrace("osmo-output/mosmo-task-" + this.id + "-i-" + i, failed, seed, this.config);
                }
            }
            ++i;
        }
        return tc;
    }
}

