/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.multiosmo;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import osmo.common.Randomizer;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.generator.SingleInstanceModelFactory;
import osmo.tester.generator.endcondition.Time;
import osmo.tester.optimizer.multiosmo.GeneratorTask;

public class MultiOSMO {
    private static final Logger log = new Logger(MultiOSMO.class);
    private OSMOConfiguration config = new OSMOConfiguration();
    private final int parallelism;
    private final ExecutorService pool;
    private final long seed;
    public static final String ERROR_MSG = "WARNING: Using factory of type " + SingleInstanceModelFactory.class + ", which means all parallel tasks share the object instances.";

    public MultiOSMO(long seed) {
        this.parallelism = Runtime.getRuntime().availableProcessors();
        this.pool = Executors.newFixedThreadPool(this.parallelism);
        this.seed = seed;
    }

    public MultiOSMO(int parallelism, long seed) {
        this.parallelism = parallelism;
        this.pool = Executors.newFixedThreadPool(parallelism);
        this.seed = seed;
    }

    public OSMOConfiguration getConfig() {
        return this.config;
    }

    public TestCoverage generate(Time time, boolean reportAll, boolean printCoverage) {
        this.check();
        this.config.setSequenceTraceRequested(false);
        this.config.setExploring(true);
        this.config.setStopGenerationOnError(false);
        ArrayList<Future<TestCoverage>> futures = new ArrayList<Future<TestCoverage>>();
        Randomizer rand = new Randomizer(this.seed);
        for (int i = 0; i < this.parallelism; ++i) {
            GeneratorTask task = new GeneratorTask(this.config, time, rand.nextLong(), reportAll, printCoverage);
            Future<TestCoverage> future = this.pool.submit(task);
            log.d("task submitted to pool");
            futures.add(future);
        }
        TestCoverage tc = new TestCoverage();
        for (Future<TestCoverage> future : futures) {
            try {
                TestCoverage ftc = future.get();
                tc.addCoverage(ftc);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to run a (Multi) OSMOTester", e);
            }
        }
        this.pool.shutdown();
        return tc;
    }

    private void check() {
        if (this.config.getFactory() instanceof SingleInstanceModelFactory) {
            System.out.println(ERROR_MSG);
        }
    }
}

