/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.reducer;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import osmo.common.TestUtils;
import osmo.common.log.Logger;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.optimizer.reducer.ReducerConfig;
import osmo.tester.optimizer.reducer.ReducerState;
import osmo.tester.optimizer.reducer.debug.Invariants;

public class Analyzer {
    private static final Logger log = new Logger(Analyzer.class);
    private final ReducerConfig config;
    private final ReducerState state;
    private Invariants invariants = null;
    private final List<String> allSteps;

    public Analyzer(List<String> allSteps, ReducerState state) {
        this.allSteps = allSteps;
        this.state = state;
        this.config = state.getConfig();
    }

    public Invariants analyze() {
        List<TestCase> tests = this.state.getTests();
        TestCase[] array = tests.toArray(new TestCase[tests.size()]);
        return this.analyze(array);
    }

    public Invariants analyze(TestCase ... tests) {
        this.invariants = new Invariants(this.allSteps);
        for (TestCase test : tests) {
            this.invariants.process(test);
            log.d("Processed:" + test);
        }
        return this.invariants;
    }

    public void writeReport(String name) {
        TestUtils.write(this.createReport(), this.getPath() + name + ".txt");
    }

    public String createReport() {
        if (this.state.getTests().size() == 0) {
            return "No failing tests found.";
        }
        VelocityEngine velocity = new VelocityEngine();
        VelocityContext vc = new VelocityContext();
        vc.put("testCount", (Object)this.state.getTestCount());
        vc.put("lengths", this.state.getLengths());
        vc.put("finalLength", (Object)this.state.getTests().get(0).getAllStepNames().size());
        vc.put("shortests", (Object)this.state.getTests().size());
        vc.put("stepCounts", this.invariants.getUsedStepCounts());
        vc.put("missingSteps", this.invariants.getMissingSteps());
        vc.put("finalSteps", this.invariants.getLastSteps());
        vc.put("s_precedences", this.invariants.getStrictPrecedences());
        vc.put("f_precedences", this.invariants.getFlexPrecedences());
        vc.put("sequences", this.invariants.getSequences());
        velocity.setProperty("resource.loader", (Object)"class");
        velocity.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        StringWriter sw = new StringWriter();
        velocity.mergeTemplate("osmo/tester/optimizer/reducer/template.vm", "UTF8", (Context)vc, (Writer)sw);
        return sw.toString();
    }

    public String getPath() {
        long seed = this.config.getSeed();
        String extension = this.config.getPathExtension();
        if (extension.length() > 0) {
            extension = "-" + extension;
        }
        return "osmo-output/reducer-" + seed + extension + "/";
    }
}

