/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.reducer;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import osmo.common.Randomizer;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.OSMOTester;
import osmo.tester.generator.endcondition.Length;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.optimizer.reducer.ReducerState;
import osmo.tester.optimizer.reducer.debug.invariants.NumberOfSteps;
import osmo.tester.scenario.Scenario;

public class FuzzerTask
implements Runnable {
    private static final Logger log = new Logger(FuzzerTask.class);
    private final OSMOConfiguration config;
    private final Randomizer seeder;
    private final ReducerState state;
    private final int populationSize;
    private static int nextId = 1;
    private final TestCase test;

    public FuzzerTask(OSMOConfiguration osmoConfig, TestCase test, long seed, ReducerState state) {
        this.config = new OSMOConfiguration(osmoConfig);
        this.seeder = new Randomizer(seed);
        this.state = state;
        this.test = test;
        this.populationSize = state.getConfig().getPopulationSize();
    }

    @Override
    public void run() {
        try {
            this.runrun();
        }
        catch (Exception e) {
            log.e("Failed to run reducer task", e);
        }
    }

    public void runrun() {
        log.i("Starting fuzz task");
        while (!this.state.isDone()) {
            int id;
            int length;
            int newMinimum;
            if (this.state.isFoundFailing()) {
                this.config.setScripts(null);
            }
            OSMOTester tester = new OSMOTester();
            tester.setConfig(this.config);
            tester.setPrintCoverage(false);
            if (this.test != null) {
                Scenario scenario = this.createScenario(this.test);
                this.config.setScenario(scenario);
            }
            if ((newMinimum = this.state.getMinimum()) > (length = this.state.getConfig().getLength())) {
                newMinimum = length;
            }
            tester.setTestEndCondition(new Length(newMinimum));
            tester.setSuiteEndCondition(new Length(this.populationSize));
            long seed = this.seeder.nextLong();
            ++nextId;
            log.d("Starting fuzzer " + id + " with seed " + seed + " and population " + this.populationSize);
            tester.generate(seed);
            this.state.testsDone(this.populationSize);
            TestSuite suite = tester.getSuite();
            List<TestCase> tests = suite.getAllTestCases();
            for (TestCase test : tests) {
                if (!this.state.getConfig().isRequirementsSearch() && !test.isFailed() || !this.state.check(test)) continue;
                this.state.addTest(test);
            }
        }
    }

    public Scenario createScenario(TestCase test) {
        Scenario scenario = new Scenario(true);
        List<String> allSteps = test.getAllStepNames();
        HashSet<String> steps = new HashSet<String>();
        steps.addAll(allSteps);
        NumberOfSteps metric = new NumberOfSteps(test);
        Map<String, Integer> counts = metric.getStepCounts();
        for (String step : steps) {
            if (this.state.getConfig().isStrictReduction()) {
                scenario.addSlice(step, 0, counts.get(step));
                continue;
            }
            scenario.addSlice(step, 0, test.getLength());
        }
        return scenario;
    }
}

