/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.reducer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import osmo.common.Randomizer;
import osmo.common.TestUtils;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.OSMOTester;
import osmo.tester.generator.SingleInstanceModelFactory;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;
import osmo.tester.optimizer.multiosmo.MultiOSMO;
import osmo.tester.optimizer.reducer.Analyzer;
import osmo.tester.optimizer.reducer.FuzzerTask;
import osmo.tester.optimizer.reducer.ReducerConfig;
import osmo.tester.optimizer.reducer.ReducerState;
import osmo.tester.optimizer.reducer.ShortenerTask;
import osmo.tester.parser.MainParser;
import osmo.tester.parser.ParserResult;

public class Reducer {
    private static final Logger log = new Logger(Reducer.class);
    private OSMOConfiguration osmoConfig = new OSMOConfiguration();
    private final int parallelism;
    private final ExecutorService pool;
    private boolean deleteOldOutput;
    private final ReducerConfig config;
    private Randomizer rand;
    private TestCase startTest = null;

    public Reducer(ReducerConfig config) {
        this.parallelism = config.getParallelism();
        this.pool = Executors.newFixedThreadPool(this.parallelism);
        this.config = config;
    }

    public OSMOConfiguration getOsmoConfig() {
        return this.osmoConfig;
    }

    public void setStartTest(TestCase startTest) {
        this.startTest = startTest;
    }

    public ReducerState search() {
        this.check();
        this.osmoConfig.setFailWhenNoWayForward(false);
        this.osmoConfig.setSequenceTraceRequested(false);
        this.osmoConfig.setExploring(true);
        this.osmoConfig.setPrintExplorationErrors(this.config.isPrintExplorationErrors());
        this.osmoConfig.setStopGenerationOnError(false);
        this.rand = new Randomizer(this.config.getSeed());
        MainParser parser = new MainParser();
        ParserResult parserResult = parser.parse(0L, this.osmoConfig.getFactory(), null);
        FSM fsm = parserResult.getFsm();
        Collection<FSMTransition> transitions = fsm.getTransitions();
        ArrayList<String> allSteps = new ArrayList<String>();
        for (FSMTransition transition : transitions) {
            allSteps.add(transition.getStringName());
        }
        ReducerState state = new ReducerState(allSteps, this.config);
        if (this.startTest != null) {
            state.addTest(this.startTest);
        }
        if (this.config.getRequirementsTarget() > 0) {
            this.requirementsSearch(state);
        } else {
            this.debugSearch(state);
        }
        this.pool.shutdown();
        this.writeReports(allSteps, state);
        return state;
    }

    private void debugSearch(ReducerState state) {
        state.startInitialSearch();
        long initialTime = this.config.getInitialUnit().toMillis(this.config.getInitialTime());
        log.i("Running initial search");
        if (this.startTest == null) {
            this.fuzz1(state, initialTime);
        }
        this.osmoConfig.setScripts(null);
        state.startShortening();
        if (state.getTests().size() == 0) {
            System.out.println("Could not find any test.");
            return;
        }
        log.i("Running shortening");
        long shorteningTime = this.config.getShorteningUnit().toMillis(this.config.getShorteningTime());
        this.shorten(state, shorteningTime);
        state.startFinalFuzz();
        long fuzzTime = this.config.getFuzzUnit().toMillis(this.config.getFuzzTime());
        log.i("Running final fuzz");
        this.fuzz2(state, fuzzTime);
        int minimum = state.getMinimum();
        state.prune();
        if (minimum < this.config.getLength()) {
            System.out.println("Got down to:" + minimum);
        } else {
            System.out.println("Failed to find errors!");
        }
    }

    private void requirementsSearch(ReducerState state) {
        boolean shouldRun = true;
        long fuzzTime = this.config.getFuzzUnit().toMillis(this.config.getFuzzTime());
        long shorteningTime = this.config.getShorteningUnit().toMillis(this.config.getShorteningTime());
        while (shouldRun) {
            state.startInitialSearch();
            log.i("Running initial search with tests:" + state.getTests());
            this.fuzz1(state, fuzzTime);
            if (state.getTests().size() > 0) {
                this.osmoConfig.setScripts(null);
                log.d("Searching with tests: " + state.getTests());
                state.startShortening();
                log.i("Running shortening");
                this.shorten(state, shorteningTime);
            }
            log.i("Next requirement");
            shouldRun = state.nextRequirement();
            log.d("Search continue status:" + shouldRun);
        }
        state.prune();
    }

    private void writeReports(List<String> allSteps, ReducerState state) {
        Analyzer analyzer = new Analyzer(allSteps, state);
        analyzer.analyze();
        analyzer.writeReport("reducer-final");
        List<TestCase> tests = state.getTests();
        ArrayList<TestCase> traced = new ArrayList<TestCase>();
        int i = 1;
        for (TestCase test : tests) {
            if (++i > 100) break;
            traced.add(test);
        }
        String filename = analyzer.getPath() + "final-tests";
        OSMOTester.writeTrace(filename, traced, this.config.getSeed(), this.osmoConfig);
        String filename2 = analyzer.getPath() + "final-fuzz-times.csv";
        TestUtils.write(state.getFinalFuzzTimes(), filename2);
    }

    private void fuzz1(ReducerState state, long waitTime) {
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        TestCase test = state.getRequirementTest();
        for (int i = 0; i < this.parallelism; ++i) {
            FuzzerTask task = new FuzzerTask(this.osmoConfig, test, this.rand.nextLong(), state);
            tasks.add(task);
        }
        this.runTasks(tasks, state, waitTime);
    }

    private void fuzz2(ReducerState state, long waitTime) {
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        List<TestCase> tests = state.getTests();
        while (tests.size() < this.parallelism) {
            tests.addAll(tests);
        }
        for (TestCase test : tests) {
            FuzzerTask task = new FuzzerTask(this.osmoConfig, test, this.rand.nextLong(), state);
            tasks.add(task);
        }
        this.runTasks(tasks, state, waitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasks(Collection<Runnable> tasks, ReducerState state, long waitTime) {
        ArrayList futures = new ArrayList();
        for (Runnable runnable : tasks) {
            Future<?> future = this.pool.submit(runnable);
            log.d("task submitted to pool");
            futures.add(future);
        }
        try {
            Iterator iterator = state;
            synchronized (iterator) {
                log.d("waiting time " + waitTime);
                if (!state.isDone()) {
                    state.wait(waitTime);
                }
            }
            log.i("Notifying state to stop just in case..");
            state.endSearch();
        }
        catch (InterruptedException e) {
            log.d("Could not sleep", e);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to run a reducer task", e);
            }
        }
    }

    private void shorten(ReducerState state, long waitTime) {
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        List<TestCase> tests = state.getTests();
        for (TestCase test : tests) {
            ShortenerTask task = new ShortenerTask(this.osmoConfig, test, this.rand.nextLong(), state);
            tasks.add(task);
        }
        this.runTasks(tasks, state, waitTime);
    }

    private void check() {
        if (this.osmoConfig.getFactory() instanceof SingleInstanceModelFactory) {
            System.out.println(MultiOSMO.ERROR_MSG);
        }
        if (this.deleteOldOutput) {
            TestUtils.recursiveDelete("osmo-output");
        }
    }

    public void setDeleteOldOutput(boolean deleteOldOutput) {
        this.deleteOldOutput = deleteOldOutput;
    }

    public boolean isDeleteOldOutput() {
        return this.deleteOldOutput;
    }
}

