/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.reducer;

import java.util.concurrent.TimeUnit;

public class ReducerConfig {
    private long shorteningTime = 5L;
    private TimeUnit shorteningUnit = TimeUnit.MINUTES;
    private long fuzzTime = 20L;
    private TimeUnit fuzzUnit = TimeUnit.MINUTES;
    private long initialTime = 20L;
    private TimeUnit initialUnit = TimeUnit.MINUTES;
    private int populationSize = 500;
    private int length = 100;
    private boolean testMode;
    private final long seed;
    private String extension = "";
    private int parallelism = Runtime.getRuntime().availableProcessors();
    private int diversity = 10;
    private int requirementsTarget = 0;
    private boolean printExplorationErrors = false;
    private int targetLength = -1;
    private boolean strictReduction = true;

    public ReducerConfig(long seed) {
        this.seed = seed;
    }

    public int getRequirementsTarget() {
        return this.requirementsTarget;
    }

    public void setRequirementsTarget(int requirementsTarget) {
        this.requirementsTarget = requirementsTarget;
    }

    public int getTargetLength() {
        return this.targetLength;
    }

    public void setTargetLength(int targetLength) {
        this.targetLength = targetLength;
    }

    public boolean isPrintExplorationErrors() {
        return this.printExplorationErrors;
    }

    public void setPrintExplorationErrors(boolean printExplorationErrors) {
        this.printExplorationErrors = printExplorationErrors;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public int getDiversity() {
        return this.diversity;
    }

    public void setDiversity(int diversity) {
        this.diversity = diversity;
    }

    public String getPathExtension() {
        return this.extension;
    }

    public void setPathExtension(String extension) {
        this.extension = extension;
    }

    public long getShorteningTime() {
        return this.shorteningTime;
    }

    public TimeUnit getShorteningUnit() {
        return this.shorteningUnit;
    }

    public void setShorteningTime(TimeUnit unit, long iterationTime) {
        this.shorteningUnit = unit;
        this.shorteningTime = iterationTime;
    }

    public long getFuzzTime() {
        return this.fuzzTime;
    }

    public TimeUnit getFuzzUnit() {
        return this.fuzzUnit;
    }

    public void setFuzzTime(TimeUnit unit, long iterationTime) {
        this.fuzzUnit = unit;
        this.fuzzTime = iterationTime;
    }

    public long getInitialTime() {
        return this.initialTime;
    }

    public TimeUnit getInitialUnit() {
        return this.initialUnit;
    }

    public void setInitialTime(TimeUnit unit, long iterationTime) {
        this.initialUnit = unit;
        this.initialTime = iterationTime;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public long getSeed() {
        return this.seed;
    }

    public boolean isRequirementsSearch() {
        return this.requirementsTarget > 0;
    }

    public void setStrictReduction(boolean strictReduction) {
        this.strictReduction = strictReduction;
    }

    public boolean isStrictReduction() {
        return this.strictReduction;
    }
}

