/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.reducer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import osmo.common.log.Logger;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.optimizer.reducer.Analyzer;
import osmo.tester.optimizer.reducer.ReducerConfig;

public class ReducerState {
    private static final Logger log = new Logger(ReducerState.class);
    private int minimum = Integer.MAX_VALUE;
    private volatile boolean done;
    private final List<TestCase> tests = new ArrayList<TestCase>();
    private final Collection<Long> hashes = new HashSet<Long>();
    private Collection<Integer> lengths = new ArrayList<Integer>();
    private final AtomicInteger testCount = new AtomicInteger(0);
    private final List<String> allSteps;
    public long startTime = Long.MIN_VALUE;
    private long timeout = -1L;
    private final ReducerConfig config;
    private String targetRequirement = null;
    private Map<String, TestCase> requirementsTests = new HashMap<String, TestCase>();
    private Collection<String> processedRequirements = new ArrayList<String>();
    private boolean foundFailing = false;
    private ReductionPhase phase = ReductionPhase.INITIAL_SEARCH;
    private String finalFuzzTimes = "";
    private boolean needReport = false;

    public ReducerState(List<String> allSteps, ReducerConfig config) {
        this.config = config;
        this.minimum = config.getLength();
        this.allSteps = allSteps;
    }

    public void startInitialSearch() {
        this.timeout = this.config.getInitialUnit().toMillis(this.config.getInitialTime());
        this.startTime = System.currentTimeMillis();
        this.phase = ReductionPhase.INITIAL_SEARCH;
        this.resetDone();
    }

    public void startShortening() {
        this.timeout = this.config.getShorteningUnit().toMillis(this.config.getShorteningTime());
        this.startTime = System.currentTimeMillis();
        this.phase = ReductionPhase.SHORTENING;
        for (TestCase test : this.tests) {
            int length = test.getLength();
            if (length >= this.minimum) continue;
            this.minimum = length;
        }
        while (this.tests.size() > 0 && this.tests.size() < this.config.getDiversity()) {
            log.i("Only " + this.tests.size() + " tests, replicating more");
            this.tests.addAll(this.tests);
        }
        log.i("Number of tests in start of shortening " + this.tests.size());
        this.resetDone();
    }

    public void startFinalFuzz() {
        this.timeout = this.config.getFuzzUnit().toMillis(this.config.getFuzzTime());
        this.startTime = System.currentTimeMillis();
        this.phase = ReductionPhase.FINAL_FUZZ;
        this.resetDone();
    }

    public ReducerConfig getConfig() {
        return this.config;
    }

    public synchronized int getMinimum() {
        return this.minimum;
    }

    public TestCase getRequirementTest() {
        return this.requirementsTests.get(this.targetRequirement);
    }

    public void resetDone() {
        this.done = false;
    }

    public boolean isDone() {
        if (this.done) {
            return true;
        }
        if (this.phase == ReductionPhase.SHORTENING && this.minimum <= this.config.getTargetLength()) {
            this.endSearch();
            return true;
        }
        this.checkTimeout();
        return this.done;
    }

    public boolean isFoundFailing() {
        return this.foundFailing;
    }

    public synchronized void addTest(TestCase test) {
        if (test.getLength() > this.minimum) {
            return;
        }
        Long hash = this.testHash(test);
        if (this.hashes.contains(hash)) {
            return;
        }
        log.i("Adding test:" + test);
        switch (this.phase) {
            case INITIAL_SEARCH: {
                this.addTestInitialSearch(test);
                break;
            }
            case SHORTENING: {
                this.addTestShortening(test);
                break;
            }
            case FINAL_FUZZ: {
                this.addTestFinalFuzz(test);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown reduction phase:" + (Object)((Object)this.phase));
            }
        }
        this.foundFailing = true;
        this.needReport = true;
        this.hashes.add(hash);
    }

    private synchronized void writeReport() {
        if (!this.needReport) {
            return;
        }
        this.needReport = false;
        String phaseId = "unknown";
        switch (this.phase) {
            case INITIAL_SEARCH: {
                phaseId = "initial";
                break;
            }
            case SHORTENING: {
                phaseId = "shorten";
                break;
            }
            case FINAL_FUZZ: {
                phaseId = "fuzz";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown reduction phase:" + (Object)((Object)this.phase));
            }
        }
        Analyzer analyzer = new Analyzer(this.allSteps, this);
        analyzer.analyze();
        analyzer.writeReport("reducer-task-" + phaseId + "-" + this.minimum);
    }

    private void addTestInitialSearch(TestCase test) {
        this.tests.add(test);
        if (this.tests.size() == this.config.getDiversity()) {
            log.i("Diversity target reached, stopping iteration.");
            this.endSearch();
        }
    }

    private void addTestShortening(TestCase test) {
        this.checkMinimum(test);
        this.tests.add(test);
    }

    private void addTestFinalFuzz(TestCase test) {
        this.checkMinimum(test);
        this.tests.add(test);
        long now = System.currentTimeMillis();
        long diff = now - this.startTime;
        this.finalFuzzTimes = this.finalFuzzTimes + this.tests.size() + ";" + diff + "\n";
    }

    public String getFinalFuzzTimes() {
        return this.finalFuzzTimes;
    }

    private void checkMinimum(TestCase test) {
        List<String> steps = test.getAllStepNames();
        int length = steps.size();
        if (length < this.minimum) {
            this.writeReport();
            this.startTime = System.currentTimeMillis();
            this.tests.clear();
            this.hashes.clear();
            this.minimum = length;
            this.lengths.add(length);
            log.i("Found smaller:" + this.minimum);
        }
    }

    private long testHash(TestCase test) {
        long hash = 0L;
        if (this.config.isRequirementsSearch()) {
            List<String> steps = test.getAllStepNames();
            for (String step : steps) {
                hash += (long)step.hashCode();
            }
        } else {
            hash += (long)test.getAllStepNames().toString().hashCode();
        }
        return hash;
    }

    public synchronized void endSearch() {
        this.done = true;
        this.writeReport();
        this.notifyAll();
    }

    public List<TestCase> getTests() {
        ArrayList<TestCase> result = new ArrayList<TestCase>();
        if (this.config.isRequirementsSearch()) {
            TestCase target = this.requirementsTests.get(this.targetRequirement);
            if (target != null) {
                result.add(target);
            }
        } else {
            result.addAll(this.tests);
        }
        return result;
    }

    public void prune() {
        Iterator<TestCase> i = this.tests.iterator();
        while (i.hasNext()) {
            TestCase test = i.next();
            if (test.getLength() <= this.minimum) continue;
            i.remove();
        }
    }

    public Map<String, TestCase> getRequirementsTests() {
        return this.requirementsTests;
    }

    public Collection<Integer> getLengths() {
        return this.lengths;
    }

    public synchronized void testsDone(int count) {
        this.testCount.addAndGet(count);
        this.checkTimeout();
        this.writeReport();
    }

    private void checkTimeout() {
        long now = System.currentTimeMillis();
        long diff = now - this.startTime;
        if (diff > this.timeout) {
            log.i("Iteration timed out");
            this.endSearch();
        }
    }

    public int getTestCount() {
        if (this.config.isTestMode()) {
            return 0;
        }
        return this.testCount.get();
    }

    public boolean check(TestCase test) {
        List<String> steps;
        int length;
        if (this.config.isRequirementsSearch()) {
            boolean ok = this.checkRequirements(test);
            if (!ok) {
                return false;
            }
            if (test.getLength() >= this.minimum) {
                return false;
            }
        }
        return (length = (steps = test.getAllStepNames()).size()) <= this.minimum;
    }

    private boolean checkRequirements(TestCase test) {
        Collection<String> requirements = test.getCoverage().getRequirements();
        for (String requirement : requirements) {
            TestCase reqTest = this.requirementsTests.get(requirement);
            if (reqTest == null || test.getLength() < reqTest.getLength()) {
                this.requirementsTests.put(requirement, test);
            }
            if (this.targetRequirement != null || this.processedRequirements.contains(requirement)) continue;
            this.targetRequirement = requirement;
            log.d("Targeting requirement:" + this.targetRequirement);
        }
        return requirements.contains(this.targetRequirement);
    }

    public synchronized boolean nextRequirement() {
        if (this.targetRequirement != null) {
            this.processedRequirements.add(this.targetRequirement);
            log.i("Processed req:" + this.targetRequirement);
        }
        this.tests.clear();
        this.hashes.clear();
        this.lengths.clear();
        String next = null;
        TestCase test = null;
        for (String reqName : this.requirementsTests.keySet()) {
            if (this.processedRequirements.contains(reqName)) continue;
            next = reqName;
            test = this.requirementsTests.get(next);
            this.tests.add(test);
            this.hashes.add(this.testHash(test));
            break;
        }
        this.minimum = test != null ? test.getLength() : Integer.MAX_VALUE;
        this.targetRequirement = next;
        log.d("New req target:" + next + " -- tests:" + this.tests);
        if (next == null) {
            log.i("Found no requirement to process next, exiting");
            return false;
        }
        return this.processedRequirements.size() < this.config.getRequirementsTarget();
    }

    private static enum ReductionPhase {
        INITIAL_SEARCH,
        SHORTENING,
        FINAL_FUZZ;

    }
}

