/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.reducer;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import osmo.common.Randomizer;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.OSMOTester;
import osmo.tester.generator.endcondition.Length;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.optimizer.reducer.ReducerState;
import osmo.tester.optimizer.reducer.debug.invariants.NumberOfSteps;
import osmo.tester.scenario.Scenario;

public class ShortenerTask
implements Runnable {
    private static final Logger log = new Logger(ShortenerTask.class);
    private final OSMOConfiguration osmoConfig;
    private final ReducerState state;
    private final Collection<String> untried = new HashSet<String>();
    private final Randomizer seeder;
    private final int populationSize;
    private static int nextId = 1;
    private TestCase previousTest;

    public ShortenerTask(OSMOConfiguration osmoConfig, TestCase previousTest, long seed, ReducerState state) {
        this.osmoConfig = new OSMOConfiguration(osmoConfig);
        this.state = state;
        this.previousTest = previousTest;
        this.seeder = new Randomizer(seed);
        this.populationSize = state.getConfig().getPopulationSize();
    }

    @Override
    public void run() {
        this.state.resetDone();
        log.d("Starting new shortener");
        while (!this.state.isDone()) {
            this.untried.clear();
            this.untried.addAll(this.previousTest.getAllStepNames());
            while (this.untried.size() > 0) {
                int id;
                String removeMe = this.untried.iterator().next();
                this.untried.remove(removeMe);
                Scenario scenario = this.createScenario(this.previousTest, removeMe);
                OSMOTester tester = new OSMOTester();
                this.osmoConfig.setScenario(scenario);
                tester.setConfig(this.osmoConfig);
                tester.setPrintCoverage(false);
                int newMinimum = this.previousTest.getLength() - 1;
                log.d("removed:" + removeMe + " size now:" + newMinimum + " remaining:" + this.untried);
                tester.setTestEndCondition(new Length(newMinimum));
                tester.setSuiteEndCondition(new Length(this.populationSize));
                long seed = this.seeder.nextLong();
                ++nextId;
                log.d("Starting shortener run " + id + " with seed " + seed + " and population " + this.populationSize);
                tester.generate(seed);
                this.state.testsDone(this.populationSize);
                TestSuite suite = tester.getSuite();
                List<TestCase> tests = suite.getAllTestCases();
                for (TestCase test : tests) {
                    if (!this.state.getConfig().isRequirementsSearch() && !test.isFailed() || !this.state.check(test)) continue;
                    this.previousTest = test;
                    this.state.addTest(test);
                    this.untried.clear();
                }
                log.d("Finished with step " + removeMe);
            }
        }
    }

    public Scenario createScenario(TestCase test, String removeMe) {
        Scenario scenario = new Scenario(true);
        List<String> allSteps = test.getAllStepNames();
        HashSet<String> steps = new HashSet<String>();
        steps.addAll(allSteps);
        NumberOfSteps metric = new NumberOfSteps(test);
        Map<String, Integer> counts = metric.getStepCounts();
        for (String step : steps) {
            int max = counts.get(step);
            if (step.equals(removeMe)) {
                --max;
            }
            if (max <= 0) continue;
            scenario.addSlice(step, 0, max);
        }
        return scenario;
    }
}

