/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.reducer.debug;

import java.util.Collection;
import java.util.List;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.optimizer.reducer.debug.invariants.FlexPrecedence;
import osmo.tester.optimizer.reducer.debug.invariants.LastSteps;
import osmo.tester.optimizer.reducer.debug.invariants.SharedSequence;
import osmo.tester.optimizer.reducer.debug.invariants.StepCounts;
import osmo.tester.optimizer.reducer.debug.invariants.StrictPrecedence;

public class Invariants {
    private final LastSteps lastSteps = new LastSteps();
    private final StepCounts stepCounts;
    private final StrictPrecedence strictPrecedence;
    private final FlexPrecedence flexPrecedence;
    private SharedSequence sequences = new SharedSequence();

    public Invariants(List<String> allSteps) {
        this.strictPrecedence = new StrictPrecedence(allSteps);
        this.flexPrecedence = new FlexPrecedence(allSteps);
        this.stepCounts = new StepCounts(allSteps);
    }

    public void process(TestCase test) {
        List<String> steps = test.getAllStepNames();
        this.sequences.init(steps);
        this.strictPrecedence.process(steps);
        this.flexPrecedence.process(steps);
        this.sequences.process(steps);
        this.stepCounts.process(steps);
        this.lastSteps.process(steps);
    }

    public Collection<String> getLastSteps() {
        return this.lastSteps.getLastSteps();
    }

    public Collection<String> getUsedStepCounts() {
        return this.stepCounts.getUsedStepCounts();
    }

    public Collection<String> getMissingSteps() {
        return this.stepCounts.getMissingStepCounts();
    }

    public Collection<String> getStrictPrecedences() {
        return this.strictPrecedence.getPatterns();
    }

    public Collection<String> getFlexPrecedences() {
        return this.flexPrecedence.getPatterns();
    }

    public Collection<String> getSequences() {
        return this.sequences.getPatterns();
    }
}

