/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.reducer.debug.invariants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlexPrecedence {
    private Map<String, Collection<String>> previousMap = new HashMap<String, Collection<String>>();
    private Map<String, Integer> globalCounts = new HashMap<String, Integer>();
    private final List<String> allSteps;

    public FlexPrecedence(List<String> allSteps) {
        this.allSteps = allSteps;
        for (String step : allSteps) {
            ArrayList<String> previous = new ArrayList<String>();
            previous.addAll(allSteps);
            previous.remove(step);
            this.previousMap.put(step, previous);
            this.globalCounts.put(step, 0);
        }
    }

    public void process(List<String> names) {
        ArrayList<String> steps = new ArrayList<String>();
        steps.add(".osmo.tester.start.step");
        steps.addAll(names);
        for (int i = 1; i < steps.size(); ++i) {
            String step = (String)steps.get(i);
            this.globalCounts.put(step, this.globalCounts.get(step) + 1);
            Collection<String> previous = this.previousMap.get(step);
            List prefix = steps.subList(0, i);
            ArrayList suffix = new ArrayList(steps.subList(i, steps.size()));
            suffix.removeAll(prefix);
            previous.removeAll(suffix);
        }
    }

    public Collection<String> getPatterns() {
        for (String step : this.globalCounts.keySet()) {
            if (this.globalCounts.get(step) != 0) continue;
            for (Collection<String> steps : this.previousMap.values()) {
                steps.remove(step);
            }
            this.previousMap.get(step).clear();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String name : this.previousMap.keySet()) {
            Collection<String> values = this.previousMap.get(name);
            for (String value : values) {
                result.add(value + "->" + name);
            }
        }
        Collections.sort(result);
        return result;
    }
}

