/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.reducer.debug.invariants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class SharedSequence {
    private Collection<String> sequences = new HashSet<String>();
    private boolean initialized = false;

    public void init(List<String> steps) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.sequences.addAll(this.sequencesFor(steps));
    }

    public Collection<String> sequencesFor(List<String> steps) {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i <= steps.size(); ++i) {
            for (int ii = i + 1; ii <= steps.size(); ++ii) {
                result.add(steps.subList(i, ii).toString());
            }
        }
        return result;
    }

    public void process(List<String> steps) {
        Collection<String> seqs = this.sequencesFor(steps);
        this.sequences.retainAll(seqs);
    }

    public Collection<String> getPatterns() {
        ArrayList<String> duplicates = new ArrayList<String>();
        block0: for (String seq1 : this.sequences) {
            String check = seq1.substring(1, seq1.length() - 1);
            for (String seq2 : this.sequences) {
                if (!seq2.contains(check) || seq1.equals(seq2)) continue;
                duplicates.add(seq1);
                continue block0;
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.sequences);
        result.removeAll(duplicates);
        Collections.sort(result);
        return result;
    }
}

