/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.reducer.debug.invariants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StepCounts {
    private Map<String, StepCount> stepCounts = new LinkedHashMap<String, StepCount>();

    public StepCounts(List<String> allSteps) {
        for (String step : allSteps) {
            this.stepCounts.put(step, new StepCount(step));
        }
    }

    public void process(List<String> steps) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (String step : steps) {
            Integer count = (Integer)counts.get(step);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            counts.put(step, count);
        }
        for (StepCount stepCount : this.stepCounts.values()) {
            stepCount.process(counts);
        }
    }

    public Collection<String> getUsedStepCounts() {
        ArrayList<String> strs = new ArrayList<String>();
        for (StepCount stepCount : this.stepCounts.values()) {
            if (stepCount.max <= 0) continue;
            strs.add(stepCount.toString());
        }
        return strs;
    }

    public Collection<String> getMissingStepCounts() {
        ArrayList<String> strs = new ArrayList<String>();
        for (StepCount stepCount : this.stepCounts.values()) {
            if (stepCount.max != 0) continue;
            strs.add(stepCount.name);
        }
        return strs;
    }

    private static class StepCount {
        private final String name;
        private int min = Integer.MAX_VALUE;
        private int max = Integer.MIN_VALUE;

        private StepCount(String name) {
            this.name = name;
        }

        public void process(Map<String, Integer> counts) {
            Integer count = counts.get(this.name);
            if (count == null) {
                count = 0;
            }
            if (count < this.min) {
                this.min = count;
            }
            if (count > this.max) {
                this.max = count;
            }
        }

        public String toString() {
            String str = this.name + " : ";
            if (this.min == this.max) {
                return str + this.min;
            }
            return str + this.min + "-" + this.max;
        }
    }
}

