/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.optimizer.reducer.debug.invariants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StrictPrecedence {
    private Map<String, Collection<String>> previousMap = new HashMap<String, Collection<String>>();
    private final List<String> allSteps;

    public StrictPrecedence(List<String> allSteps) {
        this.allSteps = allSteps;
        for (String step : allSteps) {
            ArrayList<String> previous = new ArrayList<String>();
            previous.addAll(allSteps);
            previous.remove(step);
            this.previousMap.put(step, previous);
        }
    }

    public void process(List<String> names) {
        for (String step : this.allSteps) {
            if (names.contains(step)) continue;
            this.previousMap.get(step).clear();
        }
        ArrayList<String> steps = new ArrayList<String>();
        steps.add(".osmo.tester.start.step");
        steps.addAll(names);
        for (int i = 1; i < steps.size(); ++i) {
            String step = (String)steps.get(i);
            Collection<String> previous = this.previousMap.get(step);
            previous.retainAll(steps.subList(0, i));
        }
    }

    public Collection<String> getPatterns() {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : this.previousMap.keySet()) {
            Collection<String> values = this.previousMap.get(name);
            for (String value : values) {
                result.add(value + "->" + name);
            }
        }
        Collections.sort(result);
        return result;
    }
}

