/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.parser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import osmo.common.Randomizer;
import osmo.common.log.Logger;
import osmo.tester.annotation.AfterSuite;
import osmo.tester.annotation.AfterTest;
import osmo.tester.annotation.BeforeSuite;
import osmo.tester.annotation.BeforeTest;
import osmo.tester.annotation.CoverageValue;
import osmo.tester.annotation.Description;
import osmo.tester.annotation.EndCondition;
import osmo.tester.annotation.ExplorationEnabler;
import osmo.tester.annotation.GenerationEnabler;
import osmo.tester.annotation.Group;
import osmo.tester.annotation.Guard;
import osmo.tester.annotation.LastStep;
import osmo.tester.annotation.Post;
import osmo.tester.annotation.Pre;
import osmo.tester.annotation.TestStep;
import osmo.tester.annotation.Variable;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;
import osmo.tester.model.ModelFactory;
import osmo.tester.model.Requirements;
import osmo.tester.model.TestModels;
import osmo.tester.model.data.SearchableInput;
import osmo.tester.parser.AnnotationParser;
import osmo.tester.parser.ModelObject;
import osmo.tester.parser.ParserParameters;
import osmo.tester.parser.ParserResult;
import osmo.tester.parser.annotation.AfterSuiteParser;
import osmo.tester.parser.annotation.AfterTestParser;
import osmo.tester.parser.annotation.BeforeSuiteParser;
import osmo.tester.parser.annotation.BeforeTestParser;
import osmo.tester.parser.annotation.CoverageValueParser;
import osmo.tester.parser.annotation.DescriptionParser;
import osmo.tester.parser.annotation.EndConditionParser;
import osmo.tester.parser.annotation.ExplorationEnablerParser;
import osmo.tester.parser.annotation.GenerationEnablerParser;
import osmo.tester.parser.annotation.GroupParser;
import osmo.tester.parser.annotation.GuardParser;
import osmo.tester.parser.annotation.LastStepParser;
import osmo.tester.parser.annotation.PostParser;
import osmo.tester.parser.annotation.PreParser;
import osmo.tester.parser.annotation.TestStepParser;
import osmo.tester.parser.annotation.VariableParser;
import osmo.tester.parser.field.RandomizerParser;
import osmo.tester.parser.field.RequirementsParser;
import osmo.tester.parser.field.SearchableInputParser;
import osmo.tester.parser.field.TestSuiteParser;

public class MainParser {
    private static final Logger log = new Logger(MainParser.class);
    private final Map<Class<? extends Annotation>, AnnotationParser> annotationParsers = new LinkedHashMap<Class<? extends Annotation>, AnnotationParser>();
    private final Map<Class, AnnotationParser> fieldParsers = new LinkedHashMap<Class, AnnotationParser>();

    public MainParser() {
        this.annotationParsers.put(TestStep.class, new TestStepParser());
        this.annotationParsers.put(Guard.class, new GuardParser());
        this.annotationParsers.put(LastStep.class, new LastStepParser());
        this.annotationParsers.put(AfterTest.class, new AfterTestParser());
        this.annotationParsers.put(BeforeTest.class, new BeforeTestParser());
        this.annotationParsers.put(AfterSuite.class, new AfterSuiteParser());
        this.annotationParsers.put(BeforeSuite.class, new BeforeSuiteParser());
        this.annotationParsers.put(Pre.class, new PreParser());
        this.annotationParsers.put(Post.class, new PostParser());
        this.annotationParsers.put(EndCondition.class, new EndConditionParser());
        this.annotationParsers.put(CoverageValue.class, new CoverageValueParser());
        this.annotationParsers.put(Variable.class, new VariableParser());
        this.annotationParsers.put(ExplorationEnabler.class, new ExplorationEnablerParser());
        this.annotationParsers.put(GenerationEnabler.class, new GenerationEnablerParser());
        this.annotationParsers.put(Group.class, new GroupParser());
        this.annotationParsers.put(Description.class, new DescriptionParser());
        this.fieldParsers.put(SearchableInput.class, new SearchableInputParser());
        this.fieldParsers.put(Requirements.class, new RequirementsParser());
        this.fieldParsers.put(TestSuite.class, new TestSuiteParser());
        this.fieldParsers.put(Randomizer.class, new RandomizerParser());
    }

    public ParserResult parse(long seed, ModelFactory factory, TestSuite suite) {
        log.d("parsing");
        FSM fsm = new FSM();
        ParserResult result = new ParserResult(fsm);
        ParserParameters parameters = new ParserParameters();
        parameters.setSuite(suite);
        parameters.setSeed(seed);
        String errors = "";
        TestModels models = new TestModels();
        factory.createModelObjects(models);
        if (models.size() == 0) {
            errors = errors + "No model objects given. Cannot generate anything.\n";
        }
        for (ModelObject mo : models.getModels()) {
            parameters.reset();
            String prefix = mo.getPrefix();
            parameters.setPrefix(prefix);
            Object obj = mo.getObject();
            parameters.setModel(obj);
            errors = errors + this.parseClass(result, parameters);
            errors = errors + this.parseFields(result, parameters);
            errors = errors + this.parseMethods(result, parameters);
        }
        fsm.checkFSM(errors);
        result.postProcess();
        return result;
    }

    private String parseClass(ParserResult result, ParserParameters parameters) {
        Class clazz = parameters.getModelClass();
        Annotation[] annotations = clazz.getAnnotations();
        String errors = "";
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            log.d("class annotation:" + annotationClass);
            AnnotationParser parser = this.annotationParsers.get(annotationClass);
            if (parser == null) continue;
            log.d("parser:" + parser);
            parameters.setAnnotation(annotation);
            errors = errors + parser.parse(result, parameters);
        }
        return errors;
    }

    private String parseFields(ParserResult result, ParserParameters parameters) {
        Object obj = parameters.getModel();
        Collection<Field> fields = MainParser.getAllFields(obj.getClass());
        log.d("fields " + fields.size());
        String errors = "";
        for (Field field : fields) {
            log.d("field:" + field);
            parameters.setField(field);
            Annotation[] annotations = field.getAnnotations();
            parameters.setFieldAnnotations(annotations);
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> annotationClass = annotation.annotationType();
                log.d("field annotation:" + annotationClass);
                AnnotationParser parser = this.annotationParsers.get(annotationClass);
                if (parser == null) continue;
                log.d("parser:" + parser);
                parameters.setAnnotation(annotation);
                errors = errors + parser.parse(result, parameters);
            }
            errors = this.parseField(field, result, parameters, errors);
        }
        return errors;
    }

    private String parseField(Field field, ParserResult result, ParserParameters parameters, String errors) {
        log.d("parsefield");
        Class<?> fieldClass = field.getType();
        for (Class parserType : this.fieldParsers.keySet()) {
            AnnotationParser fieldParser;
            if (!parserType.isAssignableFrom(fieldClass) || (fieldParser = this.fieldParsers.get(parserType)) == null) continue;
            log.d("field parser invocation:" + parameters);
            errors = errors + fieldParser.parse(result, parameters);
        }
        return errors;
    }

    public static Collection<Field> getAllFields(Class clazz) {
        Class superclass = clazz.getSuperclass();
        ArrayList<Field> fields = new ArrayList<Field>();
        if (superclass != null) {
            fields.addAll(MainParser.getAllFields(superclass));
        }
        Collections.addAll(fields, clazz.getDeclaredFields());
        return fields;
    }

    private String parseMethods(ParserResult result, ParserParameters parameters) {
        Object obj = parameters.getModel();
        Collection<Method> methods = this.getAllMethods(obj.getClass());
        log.d("methods " + methods.size());
        String errors = "";
        for (Method method : methods) {
            Annotation[] annotations;
            log.d("method:" + method);
            parameters.setMethod(method);
            for (Annotation annotation : annotations = method.getAnnotations()) {
                Class<? extends Annotation> annotationClass = annotation.annotationType();
                log.d("class:" + annotationClass);
                AnnotationParser parser = this.annotationParsers.get(annotationClass);
                if (parser == null) continue;
                log.d("parser:" + parser);
                parameters.setAnnotation(annotation);
                errors = errors + parser.parse(result, parameters);
            }
        }
        return errors;
    }

    private Collection<Method> getAllMethods(Class clazz) {
        Class superclass = clazz.getSuperclass();
        ArrayList<Method> methods = new ArrayList<Method>();
        if (superclass != null) {
            methods.addAll(this.getAllMethods(superclass));
        }
        Collections.addAll(methods, clazz.getMethods());
        Collections.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return methods;
    }
}

