/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.parser;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;
import osmo.tester.model.InvocationTarget;
import osmo.tester.model.Requirements;

public class ParserResult {
    private final FSM fsm;
    private Requirements requirements = null;
    private Map<String, String> descriptions = new HashMap<String, String>();

    public ParserResult(FSM fsm) {
        this.fsm = fsm;
    }

    public FSM getFsm() {
        return this.fsm;
    }

    public Requirements getRequirements() {
        return this.requirements;
    }

    public void setRequirements(Requirements requirements) {
        this.requirements = requirements;
    }

    public void addDescription(InvocationTarget target, String description) {
        this.descriptions.put(this.idFor(target), description);
    }

    private String idFor(InvocationTarget target) {
        String methodName = target.getMethod().getName();
        int hash = System.identityHashCode(target.getModelObject());
        return hash + methodName;
    }

    public void postProcess() {
        HashSet<InvocationTarget> targets = new HashSet<InvocationTarget>();
        targets.addAll(this.fsm.getBeforeTests());
        targets.addAll(this.fsm.getBeforeSuites());
        Collection<FSMTransition> steps = this.fsm.getTransitions();
        for (FSMTransition step : steps) {
            targets.addAll(step.getGuards());
            targets.addAll(step.getPreMethods());
            targets.addAll(step.getPostMethods());
        }
        targets.addAll(this.fsm.getAfterTests());
        targets.addAll(this.fsm.getAfterSuites());
        targets.addAll(this.fsm.getEndConditions());
        targets.addAll(this.fsm.getExplorationEnablers());
        targets.addAll(this.fsm.getGenerationEnablers());
        for (InvocationTarget target : targets) {
            String desc = this.descriptions.get(this.idFor(target));
            if (desc == null) continue;
            target.setDescription(desc);
        }
    }
}

