/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.parser.annotation;

import java.lang.reflect.Method;
import osmo.common.log.Logger;
import osmo.tester.annotation.CoverageValue;
import osmo.tester.generator.testsuite.TestCaseStep;
import osmo.tester.model.CoverageMethod;
import osmo.tester.model.InvocationTarget;
import osmo.tester.parser.AnnotationParser;
import osmo.tester.parser.ParserParameters;
import osmo.tester.parser.ParserResult;

public class CoverageValueParser
implements AnnotationParser {
    private static final Logger log = new Logger(CoverageValueParser.class);

    @Override
    public String parse(ParserResult result, ParserParameters parameters) {
        String prefix;
        String variableName;
        Class<?>[] parameterTypes;
        CoverageValue cv = (CoverageValue)parameters.getAnnotation();
        Method method = parameters.getMethod();
        String errors = "";
        Class<?> returnType = method.getReturnType();
        String name = "@" + CoverageValue.class.getSimpleName();
        if (returnType != String.class) {
            errors = errors + "Invalid return type for " + name + " in (\"" + method.getName() + "()\"):" + returnType + ". Should be String.\n";
        }
        if ((parameterTypes = method.getParameterTypes()).length != 1) {
            errors = errors + name + " methods must have 1 parameter (" + TestCaseStep.class + "): \"" + method.getName() + "()\" has " + parameterTypes.length + " parameters.\n";
        }
        if (parameterTypes.length > 0 && parameterTypes[0] != TestCaseStep.class) {
            errors = errors + name + " parameter must be of type " + TestCaseStep.class + ": \"" + method.getName() + "()\" has type " + parameterTypes[0] + "\n";
        }
        if ((variableName = cv.value()).equals("")) {
            variableName = method.getName();
        }
        if ((prefix = parameters.getPrefix()) != null && prefix.length() > 0) {
            variableName = prefix + "-" + variableName;
        }
        CoverageMethod cm = new CoverageMethod(variableName, new InvocationTarget(parameters, CoverageValue.class));
        result.getFsm().addCoverageMethod(cm);
        return errors;
    }
}

