/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.parser.annotation;

import java.lang.reflect.Method;
import osmo.common.log.Logger;
import osmo.tester.annotation.EndCondition;
import osmo.tester.model.InvocationTarget;
import osmo.tester.parser.AnnotationParser;
import osmo.tester.parser.ParserParameters;
import osmo.tester.parser.ParserResult;

public class EndConditionParser
implements AnnotationParser {
    private static final Logger log = new Logger(EndConditionParser.class);

    @Override
    public String parse(ParserResult result, ParserParameters parameters) {
        Class<?>[] parameterTypes;
        EndCondition ec = (EndCondition)parameters.getAnnotation();
        Method method = parameters.getMethod();
        Class<?> returnType = method.getReturnType();
        String errors = "";
        String name = EndCondition.class.getSimpleName();
        if (returnType != Boolean.TYPE && returnType != Boolean.class) {
            errors = errors + "Invalid return type for @" + name + " (\"" + method.getName() + "()\"):" + returnType + ". Should be boolean.\n";
        }
        if ((parameterTypes = method.getParameterTypes()).length > 0) {
            errors = errors + "@" + name + " methods are not allowed to have parameters: \"" + method.getName() + "()\" has " + parameterTypes.length + " parameters.\n";
        }
        result.getFsm().addEndCondition(new InvocationTarget(parameters, EndCondition.class));
        return errors;
    }
}

