/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.parser.annotation;

import java.lang.reflect.Method;
import osmo.common.log.Logger;
import osmo.tester.annotation.ExplorationEnabler;
import osmo.tester.model.InvocationTarget;
import osmo.tester.parser.AnnotationParser;
import osmo.tester.parser.ParserParameters;
import osmo.tester.parser.ParserResult;

public class ExplorationEnablerParser
implements AnnotationParser {
    private static final Logger log = new Logger(ExplorationEnablerParser.class);

    @Override
    public String parse(ParserResult result, ParserParameters parameters) {
        Class<?>[] parameterTypes;
        ExplorationEnabler enabler = (ExplorationEnabler)parameters.getAnnotation();
        Method method = parameters.getMethod();
        String errors = "";
        Class<?> returnType = method.getReturnType();
        String name = "@" + ExplorationEnabler.class.getSimpleName();
        if (returnType != Void.TYPE && returnType != Void.class) {
            errors = errors + "Invalid return type for " + name + " (\"" + method.getName() + "()\"):" + returnType + ".\n";
        }
        if ((parameterTypes = method.getParameterTypes()).length > 0) {
            errors = errors + name + " methods are not allowed to have parameters: \"" + method.getName() + "()\" has " + parameterTypes.length + " parameters.\n";
        }
        result.getFsm().addExplorationEnabler(new InvocationTarget(parameters, ExplorationEnabler.class));
        return errors;
    }
}

