/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.parser.annotation;

import java.lang.reflect.Method;
import java.util.Arrays;
import osmo.common.log.Logger;
import osmo.tester.annotation.Guard;
import osmo.tester.model.FSM;
import osmo.tester.model.InvocationTarget;
import osmo.tester.model.TransitionName;
import osmo.tester.parser.AnnotationParser;
import osmo.tester.parser.ParserParameters;
import osmo.tester.parser.ParserResult;

public class GuardParser
implements AnnotationParser {
    private static final Logger log = new Logger(GuardParser.class);

    @Override
    public String parse(ParserResult result, ParserParameters parameters) {
        Class<?>[] parameterTypes;
        Guard g = (Guard)parameters.getAnnotation();
        Method method = parameters.getMethod();
        String errors = "";
        String aName = "@" + Guard.class.getSimpleName();
        Class<?> returnType = method.getReturnType();
        if (returnType != Boolean.TYPE && returnType != Boolean.class) {
            errors = errors + "Invalid return type for guard (\"" + method.getName() + "()\"):" + returnType + ".\n";
        }
        if ((parameterTypes = method.getParameterTypes()).length > 0) {
            errors = errors + "Guard methods are not allowed to have parameters: \"" + method.getName() + "()\" has " + parameterTypes.length + " parameters.\n";
        }
        String[] transitionNames = g.value();
        String prefix = parameters.getPrefix();
        for (String givenName : transitionNames) {
            TransitionName name;
            String methodName;
            FSM fsm = result.getFsm();
            InvocationTarget target = new InvocationTarget(parameters, Guard.class);
            if (givenName.equals("osmo.tester.annotations.DEFAULT_VALUE") && (givenName = GuardParser.findNameFrom(methodName = parameters.getMethod().getName())).length() == 0) {
                String msg = aName + " method name must be of format xX when using method based naming: " + methodName;
                msg = msg + ". Or if using generic association, name \"all\" must be used.\n";
                errors = errors + msg;
            }
            if (givenName.equals("all")) {
                fsm.addGenericGuard(target);
                if (transitionNames.length > 1) {
                    errors = errors + "A guard that is associated with 'all' transitions should not have any other associations defined. ";
                    errors = errors + "One had " + Arrays.asList(transitionNames) + " as a list of associations.";
                }
                return errors;
            }
            if (givenName.startsWith("!")) {
                if ((givenName = givenName.substring(1)).length() == 0) {
                    errors = errors + "Negation cannot exist without a name. You have a guard with only '!' as the name.";
                    return errors;
                }
                name = new TransitionName(prefix, givenName);
                fsm.addNegatedGuard(name, target);
                continue;
            }
            name = new TransitionName(prefix, givenName);
            fsm.addSpecificGuard(name, target);
        }
        return errors;
    }

    public static String findNameFrom(String methodName) {
        char[] chars = methodName.toCharArray();
        int i = 0;
        for (char c : chars) {
            if (Character.isUpperCase(c)) break;
            ++i;
        }
        return methodName.substring(i);
    }
}

